<div class="table">
    @if ($data->count() > 0)
    <div class="table-wrapper">
        <div class="table-header">
            <div class="row table-row-5">
                <span>@lang('table.field.no')</span>
            </div>
            <div class="row table-row-10">
                <span>@lang('table.field.profile')</span>
            </div>
            <div class="row table-row-25 text-left">
                <span>@lang('table.field.name')</span>
            </div>
            <div class="row table-row-20">
                <span>@lang('table.field.email')</span>
            </div>
            <div class="row table-row-15">
                <span>@lang('table.field.phone')</span>
            </div>
            <div class="row table-row-10">
                <span>@lang('table.field.role')</span>
            </div>
            <div class="row table-row-10">
                <span>@lang('table.field.created_at')</span>
            </div>
            <div class="row table-row-5">
                <span></span>
            </div>
        </div>
        <div class="table-body">
            @foreach ($data as $index => $item)
            <div class="column">
                <div class="row table-row-5">
                    <span>{!! $data->currentPage() * $data->perPage() - $data->perPage() + ($index + 1) !!}</span>
                </div>
                <div class="row table-row-10">
                    <div class="thumbnail" data-fancybox data-src="{{ asset('file_manager' . $item->profile)  }}">
                        <img src="{!! $item->profile != null ? asset('file_manager' . $item->profile) : asset('images/logo/default.png') !!}"
                            onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt="">
                    </div>
                </div>
                <div class="row table-row-25 text left bold">
                    <span>{!! isset($item->name_khmer) ? $item->name_khmer : '--' !!}</span>
                </div>
                <div class="row table-row-20 text">
                    <span>{!! isset($item->email) ? $item->email : '--' !!}</span>
                </div>
                <div class="row table-row-15 text">
                    <span>{!! isset($item->phone) ? $item->phone : '--' !!}</span>
                </div>
                <div class="row table-row-10">
                    <span>{!! isset($item->role) ? $item->role : '--' !!}</span>
                </div>
                <div class="row table-row-10">
                    @foreach (DateFormat::create($item->created_at) as $date)
                    <span>{!! $date !!}</span>
                    @endforeach
                </div>
                <div class="row table-row-5">
                    @canany(['student-update', 'student-view-info', 'student-assign'])
                    <div class="dropdown">
                        <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                            data-mdb-toggle="dropdown" aria-expanded="false">
                        </i>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            @can('student-view-info')
                            <li>
                                <a class="dropdown-item" s-click-link="{!! route('admin-student-view', $item->id) !!}">
                                    <i data-feather="monitor"></i>
                                    <span>View Info</span>
                                </a>
                            </li>
                            @endcan
                            @can('student-update')
                            <li>
                                <a class="dropdown-item"
                                    s-click-link="{!! route('admin-student-create', $item->id) !!}">
                                    <i data-feather="edit"></i>
                                    <span>@lang('table.option.edit')</span>
                                </a>
                            </li>
                            @endcan
                            @can('student-assign')
                            <li>
                                <a class="dropdown-item"
                                    s-click-link="{!! route('admin-student-assign-class', $item->id) !!}">
                                    <i data-feather="edit"></i>
                                    <span>Assign Class</span>
                                </a>
                            </li>
                            @endcan
                            @if ($item->id != Auth::user()->id)
                            {{-- <li>--}}
                                {{-- <a class="dropdown-item"
                                    s-click-link="{!! route('admin-student-permission', $item->id) !!}">--}}
                                    {{-- <i data-feather="sliders"></i>--}}
                                    {{-- <span>@lang('table.option.permission')</span>--}}
                                    {{-- </a>--}}
                                {{-- </li>--}}
                            {{-- <li>--}}
                                {{-- <a class="dropdown-item"
                                    s-click-link="{!! route('admin-student-permission', $item->id) !!}">--}}
                                    {{-- <i data-feather="sliders"></i>--}}
                                    {{-- <span>@lang('table.option.permission')</span>--}}
                                    {{-- </a>--}}
                                {{-- </li>--}}
                            @endif
                        </ul>
                    </div>
                    @endcan
                </div>
            </div>
            @endforeach

        </div>
        <div class="table-footer">
            @include('admin::components.pagination', ['paginate' => $data])
        </div>
    </div>
    @else
    @component('admin::components.empty', [
    'name' => 'Student is empty',
    'msg' => 'You can create a new Student by clicking the button below.',
    'permission' => 'student-create',
    'url' => route('admin-student-create'),
    'button' => 'Create New Student',
    ])
    @endcomponent
    @endif
</div>