@extends('admin::shared.layout')
@section('layout')
    <div class="content-wrapper">
        <div class="header">
            @include('admin::shared.header', ['header_name' => 'Staff Management'])
            <div class="header-tab">
                <div class="header-tab-wrapper">
                    <div class="menu-row">
                        <div class="menu-item {!! Request::is('admin/staff/list/1') ? 'active' : '' !!}" s-click-link="{!! route('admin-staff-list', 1) !!}">
                          Active</div>
                        <div class="menu-item {!! Request::is('admin/staff/list/2') ? 'active' : '' !!}" s-click-link="{!! route('admin-staff-list', 2) !!}">
                            Disable</div>
                    </div>
                </div>
                <div class="header-action-button">
                    <form class="filter" action="{!! url()->current() !!}" method="GET">
                        <div class="form-row">
                            <input type="text" name="keyword" placeholder="Staff filter search"
                                value="{!! request('keyword') !!}">
                            <i data-feather="filter"></i>
                        </div>
                        <button mat-flat-button type="submit" class="btn-create bg-success">
                            <i data-feather="search"></i>
                            <span>Search</span>
                        </button>
                    </form>
                    @can('staff-create')
                        <button class="btn-create" s-click-link="{!! route('admin-staff-create') !!}">
                            <i data-feather="plus-circle"></i>
                            <span>Create New Staff</span>
                        </button>
                    @endcan
                    <button s-click-link="{!! url()->current() !!}">
                        <i data-feather="refresh-ccw"></i>
                        <span>Reload</span>
                    </button>
                </div>
            </div>
        </div>
        <div class="content-body">
            @include('admin::pages.staff.table')
        </div>
    </div>
@stop
@section('script')
    <script>

    </script>
@stop
