@extends('admin::shared.layout')
@section('layout')
    <div class="form-admin">
        <div class="form-bg"></div>
        <form id="form" class="form-wrapper" action="{!! route('admin-staff-save', request('id')) !!}" method="POST" enctype="multipart/form-data">
            <div class="form-header">
                <h3>
                    <i data-feather="arrow-left" s-click-link="{!! route('admin-staff-list', 1) !!}"></i>
                    {!! request('id') ? "Update Staff" : "Create Staff" !!}
                </h3>
            </div>
            {{ csrf_field() }}
            <div class="form-body">
                <div class="row-2">
                    <div class="form-row">
                        <label>Staff Type <span>*</span></label>
                        <select name="staff_type_id">
                            @foreach($staff_type as $value)
                                <option value="{!!$value->id!!}">{!!$value->name!!}</option>
                            @endforeach
                        </select>
                    </div>
                     <div class="form-row">
                        <label>Staff Position <span>*</span></label>
                        <select name="staff_position_id" id="">
                            <option value="">Please select staff position</option>
                            @foreach($staff_positions as $staff_position)
                            <option value="{{$staff_position->id}}">{{$staff_position->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="row-2">
                     <div class="form-row">
                        <label>Full Name<span>*</span> </label>
                        <input type="text" name="name" value="{!! request('id') ? $data->full_name : old('full_name') !!}"
                            placeholder="Staff full name">
                        @error('name')
                        <span class="error">@lang("message.".$message)</span>
                        @enderror
                    </div>
                    <div class="form-row">
                        <label>Phone</label>
                        <input type="text" name="phone" value="{!! request('id') ? $data->phone : old('phone') !!}" data-old="{!! request('id') ? $data->phone : old('phone') !!}"
                            placeholder="Enter Phone" autocomplete="off">
                        @error('phone')
                            <span class="error">@lang("message.".$message)</span>
                        @enderror
                    </div>
                </div>
                <div class="row-2">
                     <div class="form-row">
                        <label>Email</label>
                        <input type="email" name="email" value="{!! request('id') ? $data->email : old('email') !!}" placeholder="Email" autocomplete="off">
                        @error('email')
                        <span class="error">@lang("message.".$message)</span>
                        @enderror
                    </div>
                    <div class="form-row">
                        <label>Gender<span>*</span> </label>
                        <select name="gender">
                            <option value="F" {!! (request('id') && $data->gender == "F") ? 'selected' : '' !!}>Female</option>
                            <option value="M" {!! (request('id') && $data->gender == "M") ? 'selected' : '' !!}>Male</option>
                        </select>
                    </div>
                </div>
                <div class="row">
                    <div class="form-row">
                        <label>Status<span>*</span></label>
                        <select name="status">
                            <option value="1" {!! (request('id') && $data->status == 1) || old('status') == 1 ? 'selected' : '' !!}>Active</option>
                            <option value="2" {!! (request('id') && $data->status == 2) || old('status') == 2 ? 'selected' : '' !!}>In Active</option>
                        </select>
                    </div>
                </div>
                <div class="row">
                    <div class="form-row">
                        <label>Note </label>
                        <textarea name="noted" placeholder="">{!! request('id') ? $data->noted : old('noted') !!}</textarea>
                        @error('noted')
                        <span class="error">@lang("message.".$message)</span>
                        @enderror
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>Profile</label>
                        <div class="form-select-photo image">
                            <div class="select-photo {!! request('id') && isset($data) && $data->profile != null ? 'active' : '' !!}">
                                <div class="icon">
                                    <i data-feather="image"></i>
                                </div>
                                <div class="title">
                                    <span>Profile</span>
                                </div>
                            </div>
                            <div class="image-view {!! request('id') && isset($data) && $data->profile != null ? 'active' : '' !!}" >
                                <img src="{!! request('id') && isset($data) && $data->profile != null ? asset('file_manager' . $data->profile) : null !!}"  onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt="">
                            </div>
                            <input type="text" name="image" s-click-fn="selectImage(event)" autocomplete="off"
                                role="presentation">
                            <input type="hidden" name="tmp_file" value="{!! request('id') && isset($data) && $data->profile != null ? $data->profile : '' !!}">
                        </div>
                    </div>
                    {{-- <div class="form-row">
                        <label>CV</label>
                        <div class="form-select-photo image">
                            <div class="select-photo {!! request('id') && isset($data) && $data->cv != null ? 'active' : '' !!}">
                                <div class="icon">
                                    <i data-feather="image"></i>
                                </div>
                                <div class="title">
                                    <span>CV</span>
                                </div>
                            </div>
                            <div class="image-view {!! request('id') && isset($data) && $data->profile != null ? 'active' : '' !!}" >
                                <img src="{!! request('id') && isset($data) && $data->cv != null ? asset('file_manager' . $data->cv) : null !!}"  onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt="">
                            </div>
                            <input type="text" name="cv" s-click-fn="selectImage(event)" autocomplete="off"
                                   role="presentation">
                            <input type="hidden" name="cv_file" value="{!! request('id') && isset($data) && $data->cv != null ? $data->cv : '' !!}">
                        </div>
                    </div> --}}
                </div>
                <div class="form-button">
                    <button type="submit" color="primary">
                        <i data-feather="save"></i>
                        <span>Submit</span>
                    </button>
                    <button color="danger" type="button" s-click-link="{!! route('admin-staff-list', 1) !!}">
                        <i data-feather="x"></i>
                        <span>Cancel</span>
                    </button>
                </div>
            </div>
            <div class="form-footer"></div>
        </form>
    </div>
    @include('admin::file-manager.popup')
@stop

@section('script')
    <script lang="ts">
        $(document).ready(function() {
            $validator("#form", {
                staff_type_id: {
                    required: true,
                },
                staff_position_id: {
                    required: true,
                },
                name: {
                    required: true,
                },
                gender: {
                    required: true,
                },
                status: {
                    required: true,
                },
            });
        });
        function selectImage(e) {
            fileManager({
                multiple: false,
                afterClose: (data, basePath) => {
                    if (data?.length > 0) {
                        const parent = e.target.closest('.form-select-photo');
                        e.target.value = data[0].path;
                        parent
                            .querySelector('.select-photo')
                            .classList.add('active');
                        parent
                            .querySelector('.image-view')
                            .classList
                            .add('active');
                        parent
                            .querySelector('.image-view')
                            .childNodes[0]
                            .nextElementSibling
                            .setAttribute('src', basePath + data[0].path);
                    }
                }
            })
        }
    </script>
@stop
