<div class="table">
    @if ($data->count() > 0)
        <div class="table-wrapper">
            <div class="table-header">
                <div class="row table-row-5">
                    <span>Struct. ID</span>
                </div>
                <div class="row table-row-5">
                    <span>Class ID</span>
                </div>
                <div class="row table-row-15">
                    <span>Class Processing Status</span>
                </div>
                <div class="row table-row-15">
                    <span>Struct. Occupation</span>
                </div>
                <div class="row table-row-20">
                    <span>Struct. Name</span>
                </div>
                <div class="row table-row-5">
                    <span>Lesson Count</span>
                </div>
                <div class="row table-row-10">
                    <span>Total Practice HRS</span>
                </div>
                <div class="row table-row-10">
                    <span>Total Theory HRS</span>
                </div>
                <div class="row table-row-10">
                    <span>Total Day Count</span>
                </div>
                <div class="row table-row-5">
                    <span></span>
                </div>
            </div>
            <div class="table-body">
                @foreach ($data as $index => $item)
                    <div class="column">
                        <div class="row table-row-5 text">
                            <span>
                                {!! $item->structure_program_id ? $item->structure_program_id : '--' !!}
                            </span>
                        </div>
                        <div class="row table-row-5 text">
                            <span>
                                {!! $item->class_id ? $item->class_id : '--' !!}
                            </span>
                        </div>
                        <div class="row table-row-15 text">
                            <span>
                                @if($item->class_id)
                                    {!! $item->classes->class_status->name; !!}
                                @else
                                {!! '--' !!}
                                @endif
                            </span>
                        </div>
                        <div class="row table-row-15">
                            <span>
                                @if($item->structure_program_id)
                                    {!! $item->structure_program->class_occupation->name !!}
                                @else
                                {!! '--' !!}
                                @endif
                            </span>
                        </div>
                        <div class="row table-row-20">
                            <span>
                                @if($item->structure_program_id)
                                    {!! $item->structure_program->description !!}
                                @else
                                {!! '--' !!}
                                @endif
                            </span>
                        </div>
                        <div class="row table-row-5">
                            <span>
                                {!! count($item->structure_program->lesson_id) !!}
                            </span>
                        </div>
                        <div class="row table-row-10">
                            @php
                                $sum_P_hour = 0;
                            @endphp
                            <span>
                                @if($item->structure_program_id)
                                    @foreach($item->structure_program->lesson_id as $lesson_id)
                                        @foreach($lessons as $lesson)
                                            @if($lesson->id == $lesson_id)
                                                @php
                                                    $sum_P_hour += $lesson->practice_hour
                                                @endphp
                                            @endif
                                        @endforeach
                                    @endforeach
                                    {!! $sum_P_hour !!}
                                @else
                                    {!! '--' !!}
                                @endif
                            </span>
                        </div>
                        <div class="row table-row-10">
                            @php
                                $sum_T_hour = 0;
                            @endphp
                            <span>
                                @if($item->structure_program_id)
                                    @foreach($item->structure_program->lesson_id as $lesson_id)
                                        @foreach($lessons as $lesson)
                                            @if($lesson->id == $lesson_id)
                                                @php
                                                    $sum_T_hour += $lesson->theory_hour
                                                @endphp
                                            @endif
                                        @endforeach
                                    @endforeach
                                    {!! $sum_T_hour !!}
                                @else
                                    {!! '--' !!}
                                @endif
                            </span>
                        </div>
                        <div class="row table-row-10">
                            <span>
                                {!! round($sum_P_hour/3) !!}
                            </span>
                        </div>
                        <div class="row table-row-5 text right">
                            @canany(['program-class-update', 'program-class-delete'])
                                <div class="dropdown">
                                    <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                                        data-mdb-toggle="dropdown" aria-expanded="false">
                                    </i>
                                    <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                        @can('program-class-update')
                                            <li>
                                                <a class="dropdown-item" s-click-link="{!! route('admin-program-class-create', $item->id) !!}">
                                                    <i data-feather="edit"></i>
                                                    <span>@lang('table.option.edit')</span>
                                                </a>
                                            </li>
                                        @endcan
                                    </ul>
                                </div>
                            @endcan
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="table-footer">
                @include('admin::components.pagination', ['paginate' => $data])
            </div>
        </div>
    @else
        @component('admin::components.empty', [
            'name' => 'Program CLass is empty',
            'msg' => 'You can create a new program class by clicking the button below.',
            'permission' => 'program-class-create',
            'url' => route('admin-program-class-create'),
            'button' => 'Create Program CLass',
            ])
        @endcomponent
    @endif
</div>
