@extends('admin::shared.layout')
@section('layout')
    <div class="form-admin">
        <div class="form-bg"></div>
        <form id="form" class="form-wrapper" action="{!! route('admin-program-class-save', request('id')) !!}" method="POST" enctype="multipart/form-data">
            <div class="form-header">
                <h3>
                    <i data-feather="arrow-left" s-click-link="{!! route('admin-program-class-list', 1) !!}"></i>
                    {!! request('id') ? "Update Class Program" : "Create Class Program" !!}
                </h3>
            </div>
            {{ csrf_field() }}
            <div class="form-body">
                <div class="row">
                    <div class="form-row">
                        <label>Select Class <span>*</span></label>
                        <select name="class_id" disabled>
                            <option value="">Please select one class</option>
                            @foreach($class as $value)
                                <option value="{!!$value->id!!}" {!! request('id') ? $data->class_id == $value->id ? 'selected' : '' : old('class_id') !!}>
                                    [Class ID: {!! $value->id !!}]
                                    [{!! $value->shift->name !!}]
                                    [{!! $value->class_status->name !!}]
                                    [{!! $value->class_level->name !!}]
                                    [{!! $value->class_type->name !!}]
                                    [{!! $value->generation !!}]
                                    [{!! $value->group !!}]
                                </option>
                            @endforeach
                        </select>
                        @error('class_id')
                        <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="row">
                    <div class="form-row">
                        <label>Select Structure Program <span>*</span></label>
                        <select name="structure_program_id" disabled>
                            <option value="">Please select one structured program</option>
                            @foreach($structure_program as $value)
                                <option value="{!!$value->id!!}" {!! request('id') ? $data->structure_program_id == $value->id ? 'selected' : '' : old('structure_program_id') !!}>
                                    [Structure Program ID {!!$value->id!!}] [Name: {!! $value->description !!}]
                                </option>
                            @endforeach
                        </select>
                        @error('structure_program_id')
                        <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>Generic Full Score</label>
                        <input type="number" min="0" step="0.01" name="generic_full_score" value="{!! request('id') ? $data->generic_full_score : old('generic_full_score') !!}" data-old="{!! request('id') ? $data->generic_full_score : old('generic_full_score') !!}"
                            placeholder="Generic Full Score" autocomplete="off">
                        @error('generic_full_score')
                            <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                    <div class="form-row">
                        <label>Functional Full Score</label>
                        <input type="number" min="0" step="0.01" name="functional_full_score" value="{!! request('id') ? $data->functional_full_score : old('functional_full_score') !!}" placeholder="Functional Full Score" autocomplete="off">
                        @error('functional_full_score')
                        <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>Generic Subject</label>
                        <input type="number" min="0" step="1" name="generic_subject" value="{!! request('id') ? $data->generic_subject : old('generic_subject') !!}" data-old="{!! request('id') ? $data->generic_subject : old('generic_subject') !!}"
                               placeholder="Generic Subject [Default 0]" autocomplete="off">
                        @error('generic_subject')
                        <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                    <div class="form-row">
                        <label>Functional Subject</label>
                        <input type="number" min="0" step="1" name="functional_subject" value="{!! request('id') ? $data->functional_subject : old('functional_subject') !!}" placeholder="Functional Subject [Default 0]" autocomplete="off">
                        @error('functional_subject')
                        <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>Generic Score</label>
                        <input type="number" min="0" step="0.01" name="each_generic_score" value="{!! request('id') ? $data->each_generic_score : old('each_generic_score') !!}" data-old="{!! request('id') ? $data->each_generic_score : old('each_generic_score') !!}"
                               placeholder="Generic Score" autocomplete="off">
                        @error('each_generic_score')
                        <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                    <div class="form-row">
                        <label>Functional Score</label>
                        <input type="number" min="0" step="0.01" name="each_functional_score" value="{!! request('id') ? $data->each_functional_score : old('each_functional_score') !!}" placeholder="Functional Score" autocomplete="off">
                        @error('each_functional_score')
                        <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="form-button">
                    <button type="submit" color="primary">
                        <i data-feather="save"></i>
                        <span>Submit</span>
                    </button>
                    <button color="danger" type="button" s-click-link="{!! route('admin-program-class-list', 1) !!}">
                        <i data-feather="x"></i>
                        <span>Cancel</span>
                    </button>
                </div>
            </div>
            <div class="form-footer"></div>
        </form>
    </div>
    @include('admin::file-manager.popup')
@stop

@section('script')
@stop
