@extends('admin::pages.printing.header')

@section('print-body')
<div class="body-content">
    <div class="section-1">
        <div class="title d-flex justify-content-center align-items-center">
            <span id="" class="input whitespace-break span1"
                style="font-family: 'Moul', cursive !important;">តារាងស្ថានភាពវត្តមានរបស់សិស្ស</span>
        </div>
        <div class="title d-flex justify-content-center align-items-center">
            <span id="" class="input whitespace-break span5"
                style="font-family: 'Moul', cursive !important;">អំពី</span>
        </div>
    </div>
    <div class="section-2 border-c p-3 mb-3 border-radius-5">
        <h3 class="m-0" style="font-weight: 600">ពត៏មានថ្នាក់</h3>
        <div class="d-flex justify-content-between">
            <div class="part-1">
                <p>លេខកូដថ្នាក់: <span class="text-danger">{{$class->id ?? '--'}}</span></p>
                <p>គ្រូបន្ទុកថ្នាក់: <span class="text-danger">{{$class->staff->full_name ?? '--'}}</span></p>
            </div>
            <div class="part-1">
                <p>សិស្សសរុប: <span class="text-danger">{{$count}} នាក់ ( ស្រី {{$count_F}} នាក់)</span></p>
                <p>វេនសិក្សា: <span class="text-danger">{{$class->shift->name}}</span></p>
            </div>
            <div class="part-1">
                <p>ជំនាន់ទី: <span class="text-danger">{{$class->generation}}</span></p>
                <p>ក្រុមទី: <span class="text-danger">{{$class->group}}</span></p>
            </div>
            <div class="part-1">
                <p>ជំនាញនៃកម្មវិធី:
                    <span
                        class="text-danger">{{$class->class_structure_program->structure_program->class_occupation->name}}</span>
                </p>
                <p>ស្ថានភាពថ្នាក់: <span class="text-danger">{{$class->class_status->name}}</span></p>
            </div>
        </div>
    </div>
    <div class="section-3">
        <div class="table w-100 h-100">
            @if (request('show_image') == "true")
            <div class="table-wrapper p-0 border-c">
                <div class="table-header p-0 border-bottom-c">
                    <div class="row table-row-7 border-right-1 h-100 d-flex align-items-center justify-content-center">
                        <span>លេខរៀង</span>
                    </div>
                    <div class="row table-row-7 border-right-1 h-100 d-flex align-items-center justify-content-center">
                        <span>អត្តលេខ</span>
                    </div>
                    <div class="row table-row-13 border-right-1 h-100 d-flex align-items-center justify-content-center">
                        <span>ឈ្មោះ</span>
                    </div>
                    <div class="row table-row-13 border-right-1 h-100 d-flex align-items-center justify-content-center">
                        <span>ឈ្មោះ(ឡាតាំង)</span>
                    </div>
                    <div class="row table-row-12 border-right-1 h-100 d-flex align-items-center justify-content-center">
                        <span>លេខទូរស័ព្ទ</span>
                    </div>
                    <div class="row table-row-10 border-right-1 h-100 d-flex align-items-center justify-content-center">
                        <span>ភេទ</span>
                    </div>
                    <div class="row table-row-12 border-right-1 h-100 d-flex align-items-center justify-content-center">
                        <span>ថ្ងៃខែឆ្នាំកំណើត</span>
                    </div>
                    <div class="row table-row-13 border-right-1 h-100 d-flex align-items-center justify-content-center">
                        <span>ហត្តលេខា</span>
                    </div>
                    <div class="row table-row-13 border-right-1 h-100 d-flex align-items-center justify-content-center">
                        <span>រូបភាព</span>
                    </div>
                </div>
                <div class="table-body overflow-auto w-100 p-0">
                    @foreach($data as $index => $item)
                    <div class="column h-4cm border-bottom-1 p-0">
                        <div
                            class="row table-row-7 border-right-1 h-100 d-flex align-items-center justify-content-center">
                            <span>{{$index+1 ?? '--'}}</span>
                        </div>
                        <div
                            class="row table-row-7 border-right-1 h-100 d-flex align-items-center justify-content-center">
                            <span>{{$item->sid ?? '--'}}</span>
                        </div>
                        <div
                            class="row table-row-13 border-right-1 h-100 d-flex align-items-center justify-content-center">
                            <span>{{$item->name_khmer ?? '--'}}</span>
                        </div>
                        <div
                            class="row table-row-13 border-right-1 h-100 d-flex align-items-center justify-content-center">
                            <span>{{$item->name_latin ?? '--'}}</span>
                        </div>
                        <div
                            class="row table-row-12 border-right-1 h-100 d-flex align-items-center justify-content-center">
                            <span>{{$item->phone ?? '--'}}</span>
                        </div>
                        <div
                            class="row table-row-10 border-right-1 h-100 d-flex align-items-center justify-content-center">
                            <span>{{$item->gender ? $item->gender == 'F' ? 'Female, ស្រី' : 'Male, ប្រុស' :
                                'M'}}</span>
                        </div>
                        <div
                            class="row table-row-12 border-right-1 h-100 d-flex align-items-center justify-content-center">
                            <span>{{$item->dob ?? '--'}}</span>
                        </div>
                        <div
                            class="row table-row-13 border-right-1 h-100 d-flex align-items-center justify-content-center">
                            <span>ហត្តលេខា</span>
                        </div>
                        <div
                            class="row table-row-13 h-100 border-right-1 h-100 d-flex align-items-center justify-content-center">
                            <div class="thumbnail photo h-100 w-3cm m-auto" data-fancybox
                                data-src="{{ asset('file_manager' . $item->profile)  }}">
                                <img src="{!! $item->profile != null ? asset('file_manager' . $item->profile) : asset('images/logo/default.png') !!}"
                                    onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt="">
                            </div>
                        </div>
                    </div>
                    @endforeach
                    <div class="column h-auto">
                        <div class="row table-row-100">
                            <span>
                                {{$count}} នាក់ ( ស្រី {{$count_F}} នាក់)
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            @else
            <div class="table-wrapper p-0 border-c">
                <div class="table-header p-0 border-bottom-c">
                    <div class="row table-row-7 border-right-1 h-100 d-flex align-items-center justify-content-center">
                        <span>លេខរៀង</span>
                    </div>
                    <div class="row table-row-8 border-right-1 h-100 d-flex align-items-center justify-content-center">
                        <span>អត្តលេខ</span>
                    </div>
                    <div class="row table-row-20 border-right-1 h-100 d-flex align-items-center justify-content-center">
                        <span>ឈ្មោះ</span>
                    </div>
                    <div class="row table-row-20 border-right-1 h-100 d-flex align-items-center justify-content-center">
                        <span>ឈ្មោះ(ឡាតាំង)</span>
                    </div>
                    <div class="row table-row-20 border-right-1 h-100 d-flex align-items-center justify-content-center">
                        <span>លេខទូរស័ព្ទ</span>
                    </div>
                    <div class="row table-row-15 border-right-1 h-100 d-flex align-items-center justify-content-center">
                        <span>ភេទ</span>
                    </div>
                    <div class="row table-row-20 border-right-1 h-100 d-flex align-items-center justify-content-center">
                        <span>ថ្ងៃខែឆ្នាំកំណើត</span>
                    </div>
                </div>
                <div class="table-body overflow-auto w-100 p-0">
                    @foreach($data as $index => $item)
                    <div class="column border-bottom-1 p-0">
                        <div
                            class="row table-row-7 border-right-1 d-flex align-items-center justify-content-center h-100">
                            <span>{{$index+1 ?? '--'}}</span>
                        </div>
                        <div
                            class="row table-row-8 border-right-1 d-flex align-items-center justify-content-center h-100">
                            <span>{{$item->sid ?? '--'}}</span>
                        </div>
                        <div
                            class="row table-row-20 border-right-1 d-flex align-items-center justify-content-center h-100">
                            <span>{{$item->name_khmer ?? '--'}}</span>
                        </div>
                        <div
                            class="row table-row-20 border-right-1 d-flex align-items-center justify-content-center h-100">
                            <span>{{$item->name_latin ?? '--'}}</span>
                        </div>
                        <div
                            class="row table-row-20 border-right-1 d-flex align-items-center justify-content-center h-100">
                            <span>{{$item->phone ?? '--'}}</span>
                        </div>
                        <div
                            class="row table-row-15 border-right-1 d-flex align-items-center justify-content-center h-100">
                            <span>{{$item->gender ? $item->gender == 'F' ? 'Female, ស្រី' : 'Male, ប្រុស' :
                                '--'}}</span>
                        </div>
                        <div
                            class="row table-row-20 border-right-1 d-flex align-items-center justify-content-center h-100">
                            <span>{{$item->dob ?? '--'}}</span>
                        </div>
                    </div>
                    @endforeach
                    <div class="column h-auto">
                        <div class="row table-row-100">
                            <span>
                                {{$count}} នាក់ ( ស្រី {{$count_F}} នាក់)
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>
    <br />
    <br />
    <div class="section-4">
        <div class="title d-flex">
            <span class="input Battambang whitespace-break span2" id="">ថ្ងៃទី ២៥ មីនា ឆ្នាំ ២០២៣</span>
        </div>
        <div class="title d-flex">
            <span class="input Battambang whitespace-break span3" id="">នាយកសាលា</span>
        </div>
        <br />
        <br />
        <br />
        <br />
        <br />
        <div class="title d-flex">
            <span class="input Battambang whitespace-break span4" id="">ឡា វិបុល</span>
        </div>
    </div>
    @include('admin::pages.printing.setting')
    @stop