<template x-if="dialogAssignOpen">
    <div class="classLogDialogLayout">
        <div class="classLogDialog">
            <div class="content-body d-flex flex-column overflow-auto h-100">
                <div id="student-internship-place" class="bg-white mb-3">
                    <div id="student-list" class="form-body p-3">
                        <div class="form-button">
                            <h2>
                                {!! strtoupper('Groups in class') !!}
                            </h2>
                        </div>
                        <div class="row d-flex align-items-center justify-content-between">
                            <div>
                                <span>
                                    {{strtoupper('selected class id: ').request('class_id')}}
                                </span>
                                <br />
                                <span>
                                    {{strtoupper('selected group id: ')}} <span x-text="groupId"></span>
                                </span>
                            </div>
                        </div>
                        <div class="row">
                            <div class="table">
                                <div class="table-wrapper">
                                    <div class="table-header bg-black text-light">
                                        <div class="row table-row-30">
                                            <span class="font-sm">{!! strtoupper('Student id') !!}</span>
                                        </div>
                                        <div class="row table-row-35">
                                            <span class="font-sm">{!! strtoupper('Name') !!}</span>
                                        </div>
                                        <div class="row table-row-35">
                                            <span class="font-sm">{!! strtoupper('action') !!}</span>
                                        </div>
                                    </div>
                                    <div class="table-body overflow-auto">
                                        <template x-for="data in students">
                                            <div class="column">
                                                <div class="row table-row-30">
                                                    <span class="font-sm" x-text="data.id">
                                                    </span>
                                                </div>
                                                <div class="row table-row-35">
                                                    <span class="font-sm" x-text="data.name_khmer">
                                                    </span>
                                                </div>
                                                <div
                                                    class="row table-row-35 h-100 d-flex justify-content-center align-items-center">
                                                    <span class="font-sm h-50 mr-2">
                                                        <template x-if="data.groups.length < 1">
                                                            <button class="btn-create bg-primary h-100"
                                                                @click="assignStudentToGroup(data.id, {{request('class_id')}})">
                                                                <span>
                                                                    {!! strtoupper('Assign') !!}
                                                                </span>
                                                            </button>
                                                        </template>
                                                        <template x-for="item in data.groups">
                                                            <template x-if="item.id == groupId">
                                                                <button class="btn-create bg-danger h-100"
                                                                    @click="unassignStudentToGroup(data.id, {{request('class_id')}})">
                                                                    <span>
                                                                        {!! strtoupper('Unassign') !!}
                                                                    </span>
                                                                </button>
                                                            </template>
                                                        </template>
                                                        <template x-for="item in data.groups">
                                                            <template x-if="item.id != groupId">
                                                                <button class="btn-create bg-primary h-100"
                                                                    @click="assignStudentToGroup(data.id, {{request('class_id')}})">
                                                                    <span>
                                                                        {!! strtoupper('Assign') !!}
                                                                    </span>
                                                                </button>
                                                            </template>
                                                        </template>
                                                    </span>
                                                </div>
                                            </div>
                                        </template>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="d-flex justify-content-end align-items-center">
                            <button color="danger" type="button" @click="dialogUnAssignOpen()" class="bg-primary m-3">
                                <span>Refresh</span>
                            </button>
                            <button color="danger" type="button" @click="dialogAssignOpen=false" class="bg-danger">
                                <span>Close</span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</template>