<div class="table">
    @if ($data->count() > 0)
    <div class="table-wrapper">
        <div class="table-header">
            <div class="row table-row-5">
                <span>N</span>
            </div>
            <div class="row table-row-5">
                <span>Class ID</span>
            </div>
            <div class="row table-row-5">
                <span>Struct.ID</span>
            </div>
            <div class="row table-row-10">
                <span>Type</span>
            </div>
            <div class="row table-row-10">
                <span>Level</span>
            </div>
            <div class="row table-row-15">
                <span>Occupation</span>
            </div>
            <div class="row table-row-5">
                <span>Gen</span>
            </div>
            <div class="row table-row-5">
                <span>Group</span>
            </div>
            <div class="row table-row-10">
                <span>Trainer</span>
            </div>
            <div class="row table-row-15">
                <span>Processing</span>
            </div>
            <div class="row table-row-10">
                <span>Stu. Pax</span>
            </div>
            <div class="row table-row-5">
                <span></span>
            </div>
        </div>
        <div class="table-body">
            @foreach ($data as $index => $item)
            <div class="column">
                <div class="row table-row-5">
                    <span>{!! $data->currentPage() * $data->perPage() - $data->perPage() + ($index + 1) !!}</span>
                </div>
                <div class="row table-row-5">
                    <span>
                        {!! $item->id ? $item->id : "--" !!}
                    </span>
                </div>
                <div class="row table-row-5">
                    <span>
                        <a href="#">
                            {!! isset($item->class_structure_program->structure_program_id) &&
                            $item->class_structure_program->structure_program_id ?
                            $item->class_structure_program->structure_program_id : '--' !!}
                        </a>
                    </span>
                </div>
                <div class="row table-row-10">
                    <span>
                        {!! isset($item->class_type->name) && $item->class_type->name ? $item->class_type->name : '--'
                        !!}
                    </span>
                </div>
                <div class="row table-row-10">
                    <span>
                        {!! isset($item->class_level->name) && $item->class_level->name ? $item->class_level->name :
                        '--' !!}
                    </span>
                </div>
                <div class="row table-row-15">
                    <span>
                        {!! isset($item->class_structure_program->structure_program->class_occupation->name) &&
                        $item->class_structure_program->structure_program->class_occupation->name ?
                        $item->class_structure_program->structure_program->class_occupation->name : '--' !!}
                    </span>
                </div>
                <div class="row table-row-5">
                    <span>
                        {!! $item->generation ? $item->generation : '--' !!}
                    </span>
                </div>
                <div class="row table-row-5">
                    <span>
                        {!! $item->group ? $item->group : '--' !!}
                    </span>
                </div>
                <div class="row table-row-10">
                    <span>
                        {!! $item->staff->full_name ? $item->staff->full_name : '--' !!}
                    </span>
                </div>
                <div class="row table-row-15">
                    <span>
                        {!! $item->class_status->name ? $item->class_status->name : '--' !!}
                    </span>
                </div>
                <div class="row table-row-10">
                    <span>
                        {!! count($item->students) !!}p(s)
                    </span>
                </div>
                <div class="row table-row-5">
                    @canany(['class-update', 'class-view-info', 'class-study-material', 'class-image-view',
                    'exam-control-view', 'class-assign-user'])
                    <div class="dropdown">
                        <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                            data-mdb-toggle="dropdown" aria-expanded="false">
                        </i>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            @can('class-update')
                            <li>
                                <a class="dropdown-item" s-click-link="{!! route('admin-class-create', $item->id) !!}">
                                    <i data-feather="edit"></i>
                                    <span>@lang('table.option.edit')</span>
                                </a>
                            </li>
                            @endcan
                            @can('class-view-info')
                            <li>
                                <a class="dropdown-item"
                                    s-click-link="{!! route('admin-class-view-info', $item->id) !!}">
                                    <i data-feather="monitor"></i>
                                    <span>View Info</span>
                                </a>
                            </li>
                            @endcan
                            @can('class-image-view')
                            <li>
                                <a class="dropdown-item"
                                    s-click-link="{!! route('admin-class-image-list', $item->id) !!}">
                                    <i data-feather="image"></i>
                                    <span>View Class Image</span>
                                </a>
                            </li>
                            @endcan
                            @can('class-study-material')
                            <li>
                                <a class="dropdown-item"
                                    s-click-link="{!! route('admin-class-study-material', $item->id) !!}">
                                    <i data-feather="book"></i>
                                    <span>Study Material</span>
                                </a>
                            </li>
                            @endcan
                            @can('exam-control-view')
                            <li>
                                <a class="dropdown-item"
                                    s-click-link="{!! route('admin-exam-control-list', $item->id) !!}">
                                    <i data-feather="cast"></i>
                                    <span>Exam Control</span>
                                </a>
                            </li>
                            @endcan
                            @can('class-assign-user')
                            <li>
                                <a class="dropdown-item" s-click-link="{!! route('admin-class-create', $item->id) !!}">
                                    <i data-feather="user-check"></i>
                                    <span>Allow User</span>
                                </a>
                            </li>
                            @endcan
                        </ul>
                    </div>
                    @endcan
                </div>
            </div>
            @endforeach

        </div>
        <div class="table-footer">
            @include('admin::components.pagination', ['paginate' => $data])
        </div>
    </div>
    @else
    @component('admin::components.empty', [
    'name' => 'Class is empty',
    'msg' => 'You can create a new class by clicking the button below.',
    'permission' => 'class-create',
    'url' => route('admin-class-create'),
    'button' => 'Create Class',
    ])
    @endcomponent
    @endif
</div>