@extends('admin::pages.teacherPortal.index')
@section('teacher')
<div class="p-3">
    <div class="w-100 mb-4">
        <button s-click-link="{{route('admin-teacher-portal-list')}}" class="mt-2 w-100 bg-danger text-align-center"
            style="height: 30px; border-radius: 4px;">
            <span class="w-100 text-light">ថយក្រោយ</span>
        </button>
    </div>
    <div>
        <div style="text-align: center">
            <span>
                បញ្ជីឈ្មោះសិស្ស
            </span>
        </div>
        <div>
            <span>
                លេខកូដថ្នាក់: <span class="font-weight-bolder">{{request('class_id')}}</span>
            </span>
        </div>
        <div>
            <span>
                សិស្សសរុប: <span class="font-weight-bolder">{{count($data)}}</span>
            </span>
        </div>
        @if(count($data) > 0)
        <div class="content-body mb-3">
            <div class="table">
                <div class="table-wrapper">
                    <div class="table-header" style="background: #4f4f4f">
                        <div class="row table-row-10">
                            <span class="text-light">
                                លេខរៀង
                            </span>
                        </div>
                        <div class="row table-row-10">
                            <span class="text-light">
                                អត្តលេខ
                            </span>
                        </div>
                        <div class="row table-row-25">
                            <span class="text-light">
                                ឈ្មោះសិស្ស
                            </span>
                        </div>
                        <div class="row table-row-20">
                            <span class="text-light">
                                លេខទូរស័ព្ទ
                            </span>
                        </div>
                        <div class="row table-row-15">
                            <span class="text-light">
                                ផ្សេងៗ
                            </span>
                        </div>
                        <div class="row table-row-20">
                            <span class="text-light">
                                រូបភាព
                            </span>
                        </div>
                    </div>
                    <div class="table-body overflow-auto">
                        @foreach($data as $index => $item)
                        <div class="column h-col">
                            <div class="row table-row-10">
                                <span style="color: #4f4f4f">
                                    {{$index + 1}}
                                </span>
                            </div>
                            <div class="row table-row-10">
                                <span style="color: #4f4f4f">
                                    {{$item->sid ?? '--'}}
                                </span>
                            </div>
                            <div class="row table-row-25">
                                <span style="color: #4f4f4f">
                                    {{$item->name_khmer ?? '--'}}
                                </span>
                            </div>
                            <div class="row table-row-20">
                                <span style="color: #4f4f4f">
                                    {{$item->name_khmer ?? '--'}}
                                </span>
                            </div>
                            <div class="row table-row-15">
                                <span style="color: #4f4f4f">
                                    {{$item->noted ?? '--'}}
                                </span>
                            </div>
                            <div class="row table-row-20">
                                <div class="thumbnail photo" data-fancybox
                                    data-src="{{ asset('file_manager' . $item->profile)  }}">
                                    <img src="{!! $item->profile != null ? asset('file_manager' . $item->profile) : asset('images/logo/default.png') !!}"
                                        onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt=""
                                        style="width: 3cm; object-fit:contain;">
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
        @endif
    </div>
</div>
@stop