@extends('admin::shared.layout')
@section('layout')
    <div class="content-wrapper">
        <div class="header">
            @include('admin::shared.header', ['header_name' => 'Study Score Management'])
            <div class="header-tab">
                <div class="header-tab-wrapper">
                    <div class="menu-row">
                        <div class="menu-item {!! Request::is('admin/study-score/list/1') ? 'active' : '' !!}" s-click-link="{!! route('admin-study-score-list', 1) !!}">
                          Active</div>
                        <div class="menu-item {!! Request::is('admin/study-score/list/2') ? 'active' : '' !!}" s-click-link="{!! route('admin-study-score-list', 2) !!}">
                            @lang('user.tab.disable')</div>
                    </div>
                </div>
                <div class="header-action-button">
                    <form class="filter" action="{!! url()->current() !!}" method="GET">
                        <div class="form-row">
                            <input type="text" name="keyword" placeholder="@lang('user.filter.search')"
                                value="{!! request('keyword') !!}">
                            <i data-feather="filter"></i>
                        </div>
                        <button mat-flat-button type="submit" class="btn-create bg-success">
                            <i data-feather="search"></i>
                            <span>Search</span>
                        </button>
                    </form>
                    @can('study-score-create')
                        <button class="btn-create" s-click-link="{!! route('admin-study-score-create') !!}">
                            <i data-feather="plus-circle"></i>
                            <span>Create New Study Score</span>
                        </button>
                    @endcan
                    <button s-click-link="{!! url()->current() !!}">
                        <i data-feather="refresh-ccw"></i>
                        <span>Reload</span>
                    </button>
                </div>
            </div>
        </div>
        <div class="content-body">
            @include('admin::pages.studyScore.table')
        </div>
    </div>
@stop
