@extends('admin::shared.layout')
@section('layout')
<div class="form-admin">
    <div class="form-bg"></div>
    <form id="form" class="form-wrapper" action="{!! route('admin-study-score-save', request('id')) !!}" method="POST"
        enctype="multipart/form-data">
        <div class="form-header">
            <h3>
                <i data-feather="arrow-left" s-click-link="{!! route('admin-study-score-list', 1) !!}"></i>

                {!! request('id') ? 'Update Study Score' : 'Create New Study Score' !!}
            </h3>
        </div>
        {{ csrf_field() }}
        <div class="form-body">
            <div class="row-2">
                <div class="form-row">
                    <label>Generic Score<span>*</span> </label>
                    <input type="text" name="generic_score"
                        value="{!! request('id') ? $data->generic_score : old('generic_score') !!}"
                        placeholder="Generic Score">
                </div>
                <div class="form-row">
                    <label>Functional Score<span>*</span> </label>
                    <input type="text" name="functional_score"
                        value="{!! request('id') ? $data->functional_score : old('functional_score') !!}"
                        placeholder="Functional Score">
                </div>
            </div>
            <div class="row-2">
                <div class="form-row">
                    <label>Status<span>*</span></label>
                    <select name="status">
                        <option value="1" {!! (request('id') && $data->status == 1) || old('status') == 1 ? 'selected' :
                            ''
                            !!}>Active</option>
                        <option value="2" {!! (request('id') && $data->status == 2) || old('status') == 2 ? 'selected' :
                            ''
                            !!}>In Active</option>
                    </select>
                </div>
            </div>
            <div class="form-button">
                <button type="submit" color="primary">
                    <i data-feather="save"></i>
                    <span>@lang('user.form.button.submit')</span>
                </button>
                <button color="danger" type="button" s-click-link="{!! route('admin-study-score-list', 1) !!}">
                    <i data-feather="x"></i>
                    <span>@lang('user.form.button.cancel')</span>
                </button>
            </div>
        </div>
        <div class="form-footer"></div>
    </form>
</div>
@include('admin::file-manager.popup')
@stop

@section('script')

<script lang="ts">
    $(document).ready(function () {
            $validator("#form", {
                generic_score: {
                    required: true,
                },
                functional_score: {
                    required: true,
                },
            });
        });
</script>
@stop