@extends('admin::shared.layout')
@section('layout')
<div class="content-wrapper" x-data="xStudentIntern">
    <div class="header">
        @include('admin::shared.header', ['header_name' => 'Student Internship Place Mangement'])
        <div class="header-tab">
            <div class="header-tab-wrapper">
                <div class="menu-row">
                    <div class="menu-item">
                        <a href="#student-internship-place">
                            {{strtoupper('Student Intern Place')}}
                        </a>
                    </div>
                    <div class="menu-item">
                        <a href="#internship-place">
                            {{strtoupper('Internship Place')}}
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('admin::pages.studentInternPlace.table')
    <template x-if="loading">
        <div class="loading">
            <div class="sub-loading">
                <div class="loadingCus loadingCenter m-0 p-0 h-100 align-items-center flex-column" x-show="loading">
                    <div class="loaderSpinnerVer1"></div>
                    <div>Loading...</div>
                </div>
            </div>
        </div>
    </template>
</div>
@stop

@section('script')
<script>
    Alpine.data('xStudentIntern', () => ({
        dialogOpen:false,
        loading: false,
        student: [],
        class_id: null,
        student_id: null,
        internship_place_id: null,
        start_date: null,
        is_intern_pass: null,
        async studentInternPlaceLog(student_id, class_id){
            await Axios({
                    url: `{{route('admin-assign-internship-place-assign')}}`,
                    method: 'POST',
                    params: {
                        'class_id': class_id,
                        'student_id': student_id,
                        'internship_place_id': this.internship_place_id,
                        'start_date': this.start_date,
                        'is_intern_pass': this.is_intern_pass,
                    }
                }).then((res) => {
                    if (res.data.code == 20000) {
                    this.studentAttendanceOpen = false;
                    window.location.reload();
                    Toast({
                        title: 'Success Message',
                        message: res.data.message,
                        status: 'success',
                        duration: 5000,
                    });
                }else{
                    Toast({
                        title: 'Warning Message',
                        message: res.data.message,
                        status: 'warning',
                        duration: 5000,
                    });
                }
            }).catch((err)=> {
                console.log(err);
            });
        },
        init(){
        },
        async dialogClassLog(student_id, class_id){
            if(this.dialogOpen == false){
                this.loading = true;
                await this.fetchStudent(student_id, (res)=> {
                    this.student = res;
                    console.log(this.student);
                });
                this.dialogOpen = true;
                this.loading = false;
            }else{
                this.dialogOpen = false;
            }
        },
        async fetchStudent(id, callback) {
            await Axios({
                url: `{{route('admin-listing-student')}}`,
                method: 'GET',
                params: {'id': id},
            }).then((response)=>{
                callback(response.data);
            }).catch((err)=> {
                console.log(err);
            });
        },
        
    }));
</script>
@stop