@extends('admin::shared.layout')
@section('layout')
    <div class="form-admin" x-data="xService">
        <div class="form-bg"></div>
        <form id="form" class="form-wrapper" action="{!! route('admin-structure-program-save',request('id')) !!}" method="POST" enctype="multipart/form-data">
            <div class="form-header">
                <h3>
                    <i data-feather="arrow-left" s-click-link="{!! route('admin-structure-program-list', 1) !!}"></i>
                    {!! request('id') ? "Update Program Structure" : "Create Program Structure" !!}
                </h3>
            </div>
            {{ csrf_field() }}
            <div class="form-body">
                <div class="row">
                    <div class="form-row">
                        <label>Select Class Occupation <span>*</span></label>
                        <select name="class_occupation_id">
                            <option value="">Please select one of class occupation</option>
                            @foreach($class_occupations as $class_occupation)
                                <option
                                        value="{!!$class_occupation->id!!}"
                                        {!!
                                            request('id')
                                            ? $class_occupation->id == $data->class_occupation_id
                                                ? 'selected'
                                                : ''
                                            : old('class_occupation_id')
                                        !!}>
                                    {!!$class_occupation->name!!}
                                </option>
                            @endforeach
                        </select>
                        @error('class_occupation_id')
                        <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="row">
                    <div class="form-row">
                        <label>Description</label>
                        <textarea name="description" placeholder="Description">{!! request('id') ? $data->description : old('description') !!}</textarea>
                        @error('description')
                        <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="row">
                    <div class="form-row">
                        <label>Select Lesson<span>*</span></label>
                    </div>
                    <div class="gpCheckBox">
                        <div class="underLine"></div>
                        <div class="checkboxGp">
                            <div class="checkItem">
                                <select class="js-example-basic-multiple" name="lesson_id[]" multiple="multiple">
                                    @foreach($lesson_occupations as $lesson_occupation)
                                        <option disabled class="font-weight-bolder">{!! $lesson_occupation->name !!}</option>
                                        @foreach($lessons as $lesson)
                                            @if($lesson_occupation->id == $lesson->lesson_occupation_id)
                                                <option
                                                        {!!
                                                            request("id") &&
                                                            isset($data->lesson_id) &&
                                                            (is_array($data->lesson_id) ? in_array($lesson->id, $data->lesson_id) : $lesson->id == $data->lesson_id)
                                                            ? 'selected'
                                                            : ''
                                                        !!}
                                                        type="checkbox"
                                                        value="{!! $lesson->id !!}"
                                                >
                                                    {!! $lesson->name !!}
                                                </option>
                                            @endif
                                        @endforeach
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-button">
                    <button type="submit" color="primary">
                        <i data-feather="save"></i>
                        <span>Submit</span>
                    </button>
                    <button color="danger" type="button" s-click-link="{!! route('admin-structure-program-list', 1) !!}">
                        <i data-feather="x"></i>
                        <span>Cancel</span>
                    </button>
                </div>
            </div>
            <div class="form-footer"></div>
        </form>
    </div>
@stop
@section('script')
    <script>
        $(document).ready(function() {
            $('.js-example-basic-multiple').select2({
                placeholder: "search...",
                allowClear: true,
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            $validator("#form", {
                class_occupation_id: {
                    required: true,
                },
                lesson_id: {
                    required: true,
                },
            });
            document.addEventListener('contextmenu', function(e) {
                e.preventDefault();
            });
        });
    </script>
@stop
