@extends('admin::pages.printing.header')

@section('print-body')
@can('attendance-print')

<div class="body-content">
    <div class="section-1">
        <div class="title d-flex justify-content-center align-items-center">
            <span id="" class="input whitespace-break span1"
                style="font-family: 'Moul', cursive !important;">តារាងស្ថានភាពវត្តមានរបស់សិស្ស</span>
        </div>
    </div>
    <div class="section-2 border-c p-3 mb-3 border-radius-5">
        <h3 class="m-0" style="font-weight: 600">ពត៏មានថ្នាក់</h3>
        <div class="d-flex justify-content-between">
            <div class="part-1">
                <p>លេខកូដថ្នាក់: <span class="text-danger">{{$data->id ?? '--'}}</span></p>
                <p>គ្រូបន្ទុកថ្នាក់: <span class="text-danger">{{$data->staff->full_name ?? '--'}}</span></p>
            </div>
            <div class="part-1">
                <p>សិស្សសរុប: <span class="text-danger">{{$count}} នាក់ ( ស្រី {{$count_F}} នាក់)</span></p>
                <p>វេនសិក្សា: <span class="text-danger">{{$data->shift->name}}</span></p>
            </div>
            <div class="part-1">
                <p>ជំនាន់ទី: <span class="text-danger">{{$data->generation}}</span></p>
                <p>ក្រុមទី: <span class="text-danger">{{$data->group}}</span></p>
            </div>
            <div class="part-1">
                <p>ជំនាញនៃកម្មវិធី:
                    <span
                        class="text-danger">{{$data->class_structure_program->structure_program->class_occupation->name}}</span>
                </p>
                <p>ស្ថានភាពថ្នាក់: <span class="text-danger">{{$data->class_status->name}}</span></p>
            </div>
        </div>
    </div>
    @if(count($attendance) > 0)
    <div class="section-3">
        <div class="table w-100 h-100">
            <div class="table-wrapper p-0 border-c">
                <div class="table-header p-0 border-bottom-c">
                    <div class="row table-row-7 border-right-1 h-100 d-flex align-items-center justify-content-center">
                        <span>លេខរៀង</span>
                    </div>
                    <div class="row table-row-7 border-right-1 h-100 d-flex align-items-center justify-content-center">
                        <span>អត្តលេខ</span>
                    </div>
                    <div class="row table-row-15 border-right-1 h-100 d-flex align-items-center justify-content-center">
                        <span>ឈ្មោះ</span>
                    </div>
                    <div class="row table-row-12 border-right-1 h-100 d-flex align-items-center justify-content-center">
                        <span>ប្រៀបធៀប</span>
                    </div>
                    <div class="row table-row-10 border-right-1 h-100 d-flex align-items-center justify-content-center">
                        <span>ភាគរយវត្តមាន</span>
                    </div>
                    <div class="row table-row-49 border-right-1 h-100 d-flex align-items-center justify-content-center">
                        <span>របារទិន្នន័យ</span>
                    </div>
                </div>
                <div class="table-body overflow-auto w-100 p-0">
                    @php
                    $index = 0 ;
                    @endphp
                    @foreach($students as $student)
                    <div class="column border-bottom-1 p-0">
                        <div
                            class="row table-row-7 border-right-1 h-100 d-flex align-items-center justify-content-center">
                            <span>{{$index+=1 ?? '--'}}</span>
                        </div>
                        <div
                            class="row table-row-7 border-right-1 h-100 d-flex align-items-center justify-content-center">
                            <span>{{$student->sid ?? '--'}}</span>
                        </div>
                        <div
                            class="row table-row-15 border-right-1 h-100 d-flex align-items-center justify-content-center">
                            <span>{{$student->name_khmer ?? '--'}}</span>
                        </div>
                        <div
                            class="row table-row-12 border-right-1 h-100 d-flex align-items-center justify-content-center">
                            <span>{{$student->total_student_attendance ?? '--'}} / {{$total_attendance ?? '--'}}</span>
                        </div>
                        <div
                            class="row table-row-10 border-right-1 h-100 d-flex align-items-center justify-content-center">
                            <span>{!! $student->total_student_attendance != 0 ?
                                number_format((float)$student->total_student_attendance/$total_attendance*100, '2', '.',
                                '') :
                                '0.00'
                                !!}</span>
                        </div>
                        <div
                            class="row table-row-49 border-right-1 h-100 d-flex align-items-center justify-content-start">
                            <span class="bg-soft-gray c-h-25 border-r5 w-100 m-3">
                                @if(number_format((float)$student->total_student_attendance/$total_attendance*100,'2',
                                '.','') > 75)
                                <span class="bg-success h-100 d-flex justify-content-center align-items-center" style="width: {{$student->total_student_attendance != 0 ?
                                    number_format((float)$student->total_student_attendance/$total_attendance*100, '2', '.',
                                    '') :
                                    '0.00'}}%">
                                    <span class="text-light">
                                        {{$student->total_student_attendance != 0 ?
                                        number_format((float)$student->total_student_attendance/$total_attendance*100,
                                        '2', '.',
                                        '') :
                                        '0.00'}}
                                    </span>
                                </span>
                                @elseif(number_format((float)$student->total_student_attendance/$total_attendance*100,'2',
                                '.','') > 49 &&
                                number_format((float)$student->total_student_attendance/$total_attendance*100,'2',
                                '.','') < 75) <span
                                    class="bg-warning h-100 d-flex justify-content-center align-items-center" style="width: {{$student->total_student_attendance != 0 ?
                                    number_format((float)$student->total_student_attendance/$total_attendance*100, '2', '.',
                                    '') :
                                    '0.00'}}%">
                                    <span class="text-light">
                                        {{$student->total_student_attendance != 0 ?
                                        number_format((float)$student->total_student_attendance/$total_attendance*100,
                                        '2', '.',
                                        '') :
                                        '0.00'}}
                                    </span>
                            </span>
                            @else
                            <span class="bg-danger h-100 d-flex justify-content-center align-items-center" style="width: {{$student->total_student_attendance != 0 ?
                                    number_format((float)$student->total_student_attendance/$total_attendance*100, '2', '.',
                                    '') :
                                    '0.00'}}%">
                                <span class="text-light">
                                    {{$student->total_student_attendance != 0 ?
                                    number_format((float)$student->total_student_attendance/$total_attendance*100,
                                    '2', '.',
                                    '') :
                                    '0.00'}}
                                </span>
                            </span>
                            @endif
                            </span>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    <div class="d-flex">
        <div class="m-3 d-flex justify-content-center align-items-center">
            <div class="h-w bg-danger"></div>
            <span>ធ្លាក់(0->49)</span>
        </div>
        <div class="m-3 d-flex justify-content-center align-items-center">
            <div class="h-w bg-warning"></div>
            <span>មធ្យម(50->75)</span>
        </div>
        <div class="m-3 d-flex justify-content-center align-items-center">
            <div class="h-w bg-success"></div>
            <span>ល្អ(76->100)</span>
        </div>
    </div>
    <div class="section-4">
        <div class="title d-flex">
            <span class="input Battambang whitespace-break span2" id="">ថ្ងៃទី ២៥ មីនា ឆ្នាំ ២០២៣</span>
        </div>
        <div class="title d-flex">
            <span class="input Battambang whitespace-break span3" id="">នាយកសាលា</span>
        </div>
        <br />
        <br />
        <br />
        <br />
        <br />
        <div class="title d-flex">
            <span class="input Battambang whitespace-break span4" id="">ឡា វិបុល</span>
        </div>
    </div>
    @else
    <div class="text-danger font-weight-bolder">No Data!</div>
    @endif
</div>
@include('admin::pages.printing.setting')
@endcan
@stop