<div class="table">
    @if ($data->count() > 0)
        <div class="table-wrapper">
            <div class="table-header">
                <div class="row table-row-5">
                    <span>Nº</span>
                </div>
                <div class="row table-row-15">
                    <span>Occupation</span>
                </div>
                <div class="row table-row-15">
                    <span>Lesson</span>
                </div>
                <div class="row table-row-10">
                    <span>Short Name</span>
                </div>
                <div class="row table-row-15">
                    <span>Completency</span>
                </div>
                <div class="row table-row-10">
                    <span>Practice hour</span>
                </div>
                <div class="row table-row-10">
                    <span>Theory hour</span>
                </div>
                <div class="row table-row-10">
                    <span>Video</span>
                </div>
                <div class="row table-row-10">
                    <span>Document</span>
                </div>
                <div class="row table-row-5">
                    <span></span>
                </div>
            </div>
            <div class="table-body">
                @foreach ($data as $index => $item)
                    <div class="column">
                        <div class="row table-row-5">
                            <span>{!! $data->currentPage() * $data->perPage() - $data->perPage() + ($index + 1) !!}</span>
                        </div>
                        <div class="row table-row-15">
                           <span>{!! $item->occupation ? $item->occupation->name : '--' !!}</span>
                        </div>
                        <div class="row table-row-15">
                            <span>{!! $item->name ? $item->name : '--' !!}</span>
                        </div>
                        <div class="row table-row-10">
                            <span>{!! $item->short_name ? $item->short_name : '--' !!}</span>
                        </div>
                        <div class="row table-row-15">
                            <span>{!! $item->competency_type ? $item->competency_type : '--' !!}</span>
                        </div>
                        <div class="row table-row-10">
                            <span>{!! $item->practice_hour ? $item->practice_hour : '--' !!}</span>
                        </div>
                        <div class="row table-row-10">
                            <span>{!! $item->theory_hour ? $item->theory_hour : '--' !!}</span>
                        </div>
                        <div class="row table-row-10">
                            <div class="text-center">
                                <span>
                                    <a href="{!! $item->video ? $item->video : '#' !!}" target="{!! $item->video ? '_blank' : '' !!}">
                                    {!! $item->video != null ? 'Video Toturial' : '--' !!}
                                </a>
                                </span>
                            </div>
                        </div>
                        <div class="row table-row-10">
                            <div class="text-center">
                                <span>
                                    <a href="{!! $item->document != null ? asset('/uploads/file/' . $item->document) : '#' !!}" target="{!! $item->document != null ? "_blank" : '' !!}">
                                    {!! $item->document != null ? 'Doc' : '--' !!}
                                </a>
                                </span>
                            </div>
                        </div>
                        <div class="row table-row-5">
                            @canany(['lesson-update', 'lesson-delete'])
                                <div class="dropdown">
                                    <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                                        data-mdb-toggle="dropdown" aria-expanded="false">
                                    </i>
                                    <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                        @if ($item->status != 'trash')
                                            @can('lesson-update')
                                                <li>
                                                    <a class="dropdown-item" s-click-link="{!! route('admin-lesson-create', $item->id) !!}">
                                                        <i data-feather="edit"></i>
                                                        <span>Edit</span>
                                                    </a>
                                                </li>
                                                @if ($item->status == 2)
                                                    <li>
                                                        <a class="dropdown-item enable-btn"
                                                            onclick="$onConfirmMessage(
                                                                '{!! route('admin-lesson-status', ['id' => $item->id, 'status' => 1]) !!}',
                                                                '@lang('dialog.msg.enable', ['name' => $item->name])',
                                                                {
                                                                    confirm: '@lang('dialog.button.enable')',
                                                                    cancel: '@lang('dialog.button.cancel')'
                                                                },
                                                            );">
                                                            <i data-feather="rotate-ccw"></i>
                                                            <span>Enable</span>
                                                        </a>
                                                    </li>
                                                @else
                                                    <li>
                                                        <a class="dropdown-item disable-btn"
                                                            onclick="$onConfirmMessage(
                                                                '{!! route('admin-lesson-status', ['id' => $item->id, 'status' => 2]) !!}',
                                                                '@lang('dialog.msg.disable', ['name' => $item->name])',
                                                                {
                                                                    confirm: '@lang('dialog.button.disable')',
                                                                    cancel: '@lang('dialog.button.cancel')'
                                                                }
                                                            );">
                                                            <i data-feather="x-circle"></i>
                                                            <span>Disable</span>
                                                        </a>
                                                    </li>
                                                @endif
                                            @endcan
                                        @endif
                                    </ul>
                                </div>
                            @endcan
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="table-footer">
                @include('admin::components.pagination', ['paginate' => $data])
            </div>
        </div>
    @else
        @component('admin::components.empty',
            [
                'name' => 'Lesson is empty',
                'msg' => 'You can create a new class lesson by clicking the button below.',
                'permission' => 'lesson-create',
                'url' => route('admin-lesson-create'),
                'button' => 'Create lesson',
            ])
        @endcomponent
    @endif
</div>
