@extends('admin::shared.layout')
@section('layout')
<div class="content-wrapper" x-data="xExamControl">
    <div class="header">
        @include('admin::shared.header', ['header_name' => 'Exam Control'])
        <div class="header-tab">
            <div class="header-tab-wrapper">
                <div class="menu-row">
                    <div class="menu-item">
                        <a href="#exam-list">
                            {{strtoupper('Exam list')}}
                        </a>
                    </div>
                    <div class="menu-item">
                        <a href="#exam-answer-sheet">
                            {{strtoupper('Exam answer sheet')}}
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="content-body">
        @include('admin::pages.examControl.table')
    </div>
    <template x-if="loading">
        <div class="loading">
            <div class="sub-loading">
                <div class="loadingCus loadingCenter m-0 p-0 h-100 align-items-center flex-column" x-show="loading">
                    <div class="loaderSpinnerVer1"></div>
                    <div>Loading...</div>
                </div>
            </div>
        </div>
    </template>
</div>
@stop

@section('script')
<script>
    Alpine.data('xExamControl', () => ({
        // modal
        dialogOpen: false,
        loading: false,
        dialogExam: false,
        dialogSubject: false,
        dialogCandidate: false,
        status: null,
        subject: null,
        // create/update exam control
        exam_type_id: null,
        exam_date: null,
        exam_duration: null,
        exam_noted: null,
        exam_id: null,
        // load exam control data
        exam_control: [],
        // create/update exam subject
        id: null,
        sheet_issuer_id: null,
        description: null,
        google_doc_url: null,
        // exam/exam control detail
        exam_detail_id: null, 
        // load exam subject data
        exam_subject: [],
        exam_subject_show: [],
        // load student in class
        students: [],
        // load exam candidate
        exam_candidate: [],
        async dialogOpenCandidate(class_id){
            if(this.dialogCandidate == false){
                this.loading = true;
                await this.fetchStudentInClass(class_id, (res) => {
                    this.students = res;
                });
                this.dialogCandidate = true;
                this.loading = false;
            }else{
                this.dialogCandidate =false;
                window.location.reload();
            }
        },
        dialogOpenCreateESubject(){
            if(this.dialogSubject == false){
                this.subject = 1;
                this.dialogSubject = true;
            }else{
                this.dialogSubject = false;
            }
        },
        async dialogOpenUpdateESubject(id){
            if(this.dialogSubject == false){
                this.subject = 2;
                this.loading = true;
                await this.fetchExamSubjectShow(id, (res) => {
                    this.exam_subject_show = res;
                });
                this.loading = false;
                this.dialogSubject = true;
                this.id = id;
            }else{
                this.dialogSubject = false;
                this.id = null;
                this.exam_subject_show = [];
                this.sheet_issuer_id= null;
                this.description= null;
                this.google_doc_url= null;
            }
        },
        dialogOpenCreate(){
            if(this.dialogOpen == false){
                this.dialogOpen = true;
                this.status =1;
            }else{
                this.dialogOpen = false;
            }
        },
        async dialogExamDetail(exam_id, class_id) {
            this.loading = true;
            this.exam_detail_id = exam_id;
            await this.fetchExamSubject(exam_id, class_id, (res) => {
                this.exam_subject = res;
            });
            await this.fetchExamCandidate(exam_id, class_id, (res) => {
                this.exam_candidate = res;
            });
            this.reloadIcon();
            this.dialogExam = true;
            this.loading = false;
        },
        reloadIcon() {
            feather.replace();
            setTimeout(() => {
                feather.replace();
            }, 10);
        },
        async dialogOpenUpdate(exam_id){
            if(this.dialogOpen == false){
                this.dialogOpen = true;
                this.status = 2;
                this.loading = true;
                await this.fetchExamControl(exam_id, (res) => {
                    this.exam_control = res;
                });
                this.loading = false;
                this.exam_id = exam_id;
            }else{
                this.dialogOpen = false;
                this.exam_id = null;
                this.exam_type_id = null;
                this.exam_date = null;
                this.exam_duration = null;
                this.exam_noted = null;

            }
        },
        async createExamControl(class_id) {
            this.loading = true;
            await Axios({
                url: `{{route('admin-exam-control-save')}}`,
                method: 'POST',
                params: {
                    exam_id: this.exam_id,
                    class_id: class_id,
                    exam_type_id: this.exam_type_id,
                    exam_date: this.exam_date,
                    exam_duration: this.exam_duration,
                    exam_noted: this.exam_noted,
                } 
            }).then((response)=>{
                this.loading = false;
                this.dialogOpen = false;
                window.location.reload();
                if (response.data.code == 20000) {
                    Toast({
                        title: 'Success Message',
                        message: response.data.message,
                        status: 'success',
                        duration: 5000,
                    });
                }else{
                    Toast({
                        title: 'Warning Message',
                        message: response.data.message,
                        status: 'warning',
                        duration: 5000,
                    });
                }
            }).catch((err)=> {
                this.loading = false;
                Toast({
                    title: 'Warning Message',
                    message: "Invalided value",
                    status: 'warning',
                    duration: 5000,
                });
            });
        },
        async fetchExamControl(exam_id, callback){
            await Axios({
                url: `{{route('admin-exam-control-show')}}`,
                method: 'GET',
                params: {
                    exam_id:exam_id,
                }
            }).then((res) =>{
                callback(res.data);
            });
        },
        async fetchExamSubject(exam_id,class_id, callback){
            await Axios({
                url: `{{route('admin-exam-subject-list')}}`,
                method: 'GET',
                params: {
                    exam_id: exam_id,
                    class_id: class_id,
                }
            }).then((res) =>{
                callback(res.data);
            });
        },
        async fetchExamSubjectShow(id, callback){
            await Axios({
                url: `{{route('admin-exam-subject-show')}}`,
                method: 'GET',
                params: {
                    id: id,
                }
            }).then((res) =>{
                callback(res.data);
            });
        },
        async createExamSubject(class_id) {
            this.loading = true;
            await Axios({
                url: `{{route('admin-exam-subject-save')}}`,
                method: 'POST',
                params: {
                    id: this.id,
                    class_id: class_id,
                    exam_id: this.exam_detail_id,
                    sheet_issuer_id: this.sheet_issuer_id,
                    description: this.description,
                    google_doc_url: this.google_doc_url,
                } 
            }).then((response)=>{
                this.loading = false;
                // if(this.id){
                //     window.location.reload();
                // }
                if (response.data.code == 20000) {
                    this.dialogSubject = false;
                    Toast({
                        title: 'Success Message',
                        message: response.data.message,
                        status: 'success',
                        duration: 5000,
                    });
                    this.id = null;
                    this.sheet_issuer_id = null;
                    this.description = null;
                    this.google_doc_url = null;
                }else{
                    Toast({
                        title: 'Warning Message',
                        message: response.data.message,
                        status: 'warning',
                        duration: 5000,
                    });
                }
            }).catch((err)=> {
                this.loading = false;
                Toast({
                    title: 'Warning Message',
                    message: "Invalided value",
                    status: 'warning',
                    duration: 5000,
                });
            });
            await this.fetchExamSubject(this.exam_detail_id, class_id, (res) => {
                this.exam_subject = res;
            });
        },
        async fetchStudentInClass(class_id, callback) {
            await Axios({
                url: `{{route('admin-listing-student-in-class')}}`,
                method: 'GET',
                params: {
                    class_id: class_id,
                }
            }).then((res) =>{
                callback(res.data);
            });
        },
        async fetchExamCandidate(exam_id, class_id, callback) {
            await Axios({
                url: `{{route('admin-exam-candidate-list')}}`,
                method: 'GET',
                params: {
                    class_id: class_id,
                    exam_id: exam_id
                }
            }).then((res) =>{
                callback(res.data);
            });
        },
        async assignCandidate(class_id, student_id){
            this.loading = true;
            await Axios({
                url: `{{route('admin-exam-candidate-assign')}}`,
                method: 'POST',
                params: {
                    class_id: class_id,
                    student_id: student_id,
                    exam_id: this.exam_detail_id,
                }
            }).then((response) => {
                if (response.data.code == 20000) {
                    // window.location.reload();
                    Toast({
                        title: 'Success Message',
                        message: response.data.message,
                        status: 'success',
                        duration: 5000,
                    });
                }else{
                    Toast({
                        title: 'Warning Message',
                        message: response.data.message,
                        status: 'warning',
                        duration: 5000,
                    });
                }
            }).catch((err)=> {
                console.log(err);
            });
            await this.fetchExamCandidate(this.exam_detail_id, class_id, (res) => {
                this.exam_candidate = res;
            });
            this.loading = false;
        },
        async unassignCandidate(class_id, student_id){
            this.loading = true;
            await Axios({
                url: `{{route('admin-exam-candidate-unassign')}}`,
                method: 'POST',
                params: {
                    class_id: class_id,
                    student_id: student_id,
                    exam_id: this.exam_detail_id,
                }
            }).then((response) => {
                if (response.data.code == 20000) {
                    // window.location.reload();
                    Toast({
                        title: 'Success Message',
                        message: response.data.message,
                        status: 'success',
                        duration: 5000,
                    });
                }else{
                    Toast({
                        title: 'Warning Message',
                        message: response.data.message,
                        status: 'warning',
                        duration: 5000,
                    });
                }
            }).catch((err)=> {
                console.log(err);
            });
            await this.fetchExamCandidate(this.exam_detail_id, class_id, (res) => {
                this.exam_candidate = res;
            });
            this.loading = false;
        },
    }));
</script>
@stop