<div id="student-score" class="form-body p-3 mt-3">
    <h2>
        {!! strtoupper('Student score record') !!}
    </h2>
    <div class="row">
        <div class="form-row flex-row">
            @canany(['student-score-print', 'student-score-create'])
            @can('student-score-create')
            <button class="btn-create bg-primary mr-2">
                <i data-feather="monitor"></i>
                <span><a class="text-light"
                        href="{{route('admin-exam-control-enter-student-score', ['class_id' => $data->id])}}"
                        target="_blank">{!! strtoupper('view
                        entry page') !!}</a></span>
            </button>
            @endcan
            @can('student-score-print')
            <button class="btn-create bg-primary mr-2" s-click-link="">
                <i data-feather="printer"></i>
                <span>{!! strtoupper('print score table') !!}</span>
            </button>
            @endcan
            @endcan
        </div>
    </div>
    <div class="row">
        <div class="table">
            <div class="table-wrapper">
                <div class="table-header bg-black text-light">
                    <div class="row table-row-10">
                        <span class="font-sm">អត្តលេខ</span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm">ឈ្មោះ(ខ្មែរ)</span>
                    </div>
                    @foreach($lessons as $lesson)
                    <div class="row table-row-8">
                        <span class="font-sm">{!! $lesson->id.'|'.$lesson->short_name !!}</span>
                    </div>
                    @endforeach
                    <div class="row table-row-8">
                        <span class="font-sm">{!! strtoupper('total score') !!}</span>
                    </div>
                    <div class="row table-row-8">
                        <span class="font-sm">{!! strtoupper('ranking') !!}</span>
                    </div>
                    <div class="row table-row-8">
                        <span class="font-sm">{!! strtoupper('pass status') !!}</span>
                    </div>
                    <div class="row table-row-8">
                        <span class="font-sm">{!! strtoupper('actions') !!}</span>
                    </div>
                </div>
                <div class="table-body overflow-auto">
                    @foreach($data->students as $student)
                    <div class="column">
                        <div class="row table-row-10">
                            <span>
                                {!! $student->sid ?? '--' !!}
                            </span>
                        </div>
                        <div class="row table-row-10">
                            <span>
                                {!! $student->name_khmer !!}
                            </span>
                        </div>
                        @foreach($lessons as $lesson)
                        <div class="row table-row-8">
                            <span>--</span>
                        </div>
                        @endforeach
                        <div class="row table-row-8">
                            <span>--</span>
                        </div>
                        <div class="row table-row-8">
                            <span>--</span>
                        </div>
                        <div class="row table-row-8">
                            <span>--</span>
                        </div>
                        <div class="row table-row-8">
                            <span>--</span>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>