@extends('admin::shared.layout')
@section('layout')
<div class="content-wrapper" x-data='xStudyMaterial'>
    <div class=" header">
        @include('admin::shared.header', ['header_name' => 'Class Study Material'])
        <div class="header-tab">
            <div class="header-tab-wrapper">
                <div class="menu-row">
                    <div class="menu-item text-primary" s-click-link="{!! url()->previous() !!}">
                        Back</div>
                </div>
            </div>
        </div>
    </div>
    <div class="form-admin p-5 pt-4 mt-2 mb-2">
        <div class="form-wrapper p-0">
            @can('class-study-material')
            @include('admin::pages.class.studyMaterial.table')
            @endcan
        </div>
    </div>
</div>
@stop

@section('script')
<script>
    Alpine.data('xStudyMaterial', () => ({
        show: true,
        selectAll: false,
        submitCard: false,
        submitCertificate: false,
        card: false,
        certificate: false,
        selectStudents: [],
        printStudentCard(){
            if(this.submitCard == false){
                this.show = false,
                this.submitCertificate = false;
                this.certificate = false;
                this.submitCard = true;
                this.card = true;
            }else{
                this.show = true;
                this.submitCard = false;
                this.card = false;
            }
        },
        printStudentCertificate(){
            if(this.submitCertificate == false){
                this.show = false,
                this.submitCard = false;
                this.card = false;
                this.submitCertificate = true;
                this.certificate = true;
            }else{
                this.show = true;
                this.submitCertificate = false;
                this.certificate = false;
            }
        },
        toggleAllCheckboxes() {
            this.selectAll = !this.selectAll;
            this.selectStudents = [];

            checkboxes = document.querySelectorAll('.item-select-input');
            [...checkboxes].map((el) => {
                el.checked = this.selectAll;
                (this.selectAll) ? this.selectStudents.push(el.value) : this.selectStudents = [];
            });
        },
    }));
</script>
@stop