<?php $__env->startSection('layout'); ?>
    <div class="form-admin">
        <div class="form-bg"></div>
        <form id="form" class="form-wrapper" action="<?php echo route('admin-user-save', request('id')); ?>" method="POST" enctype="multipart/form-data">
            <div class="form-header">
                <h3>
                    <i data-feather="arrow-left" s-click-link="<?php echo route('admin-user-list', 1); ?>"></i>
                    <?php echo request('id')
                        ? __('user.form.title.update', ['name' => __('user.name')])
                        : __('user.form.title.create', ['name' => __('user.name')]); ?>

                </h3>
            </div>
            <?php echo e(csrf_field()); ?>

            <div class="form-body">
                <div class="row-2">
                    <div class="form-row">
                        <label><?php echo app('translator')->get('user.form.name.label'); ?><span>*</span> </label>
                        <input type="text" name="name" value="<?php echo request('id') ? $data->username : old('name'); ?>"
                            placeholder="<?php echo app('translator')->get('user.form.name.placeholder'); ?>">
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-row">
                        <label><?php echo app('translator')->get('user.form.phone.label'); ?> <span>*</span></label>
                        <input name="phone" placeholder="<?php echo app('translator')->get('user.form.phone.placeholder'); ?>" type="text"
                            value="<?php echo request('id') ? $data->phone : old('phone'); ?>">
                        <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label><?php echo app('translator')->get('user.form.email.label'); ?><span>*</span> </label>
                        <input type="text" name="email" value="<?php echo request('id') ? $data->email : old('email'); ?>"
                            data-old="<?php echo request('id') ? $data->email : old('email'); ?>" placeholder="<?php echo app('translator')->get('user.form.email.placeholder'); ?>" autocomplete="off">
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-row">
                        <label><?php echo app('translator')->get('user.form.status.label'); ?><span>*</span></label>
                        <select name="status">
                            <option value="1" <?php echo (request('id') && $data->status == 1) || old('status') == 1 ? 'selected' : ''; ?>><?php echo app('translator')->get('user.form.status.active'); ?></option>
                            <option value="2" <?php echo (request('id') && $data->status == 2) || old('status') == 2 ? 'selected' : ''; ?>><?php echo app('translator')->get('user.form.status.disable'); ?></option>
                        </select>
                        <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <?php if(!request('id')): ?>
                    <div class="row-2">
                        <div class="form-row">
                            <label><?php echo app('translator')->get('user.form.password.label'); ?><span>*</span> </label>
                            <input type="password" name="password" placeholder="<?php echo app('translator')->get('user.form.password.placeholder'); ?>"
                                autocomplete="new-password">
                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-row">
                            <label><?php echo app('translator')->get('user.form.password_confirmation.label'); ?><span>*</span> </label>
                            <input type="password" name="confirm_password" placeholder="<?php echo app('translator')->get('user.form.password_confirmation.placeholder'); ?>">
                            <?php $__errorArgs = ['confirm_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="row-2">
                    <div class="form-row">
                        <label>Branch<span>*</span></label>
                        <select name="branch_id">
                            <option value="">Select branch</option>
                            <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->id); ?>" <?php if($item->id == $data?->branch_id): echo 'selected'; endif; ?>>
                                    <?php echo e($item->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['branch_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                        <div class="form-row">
                            <label>Training Portal</label>
                            <div style="display: flex; margin-top: 5px;">
                                <input id="role" style="width: 20px; height: 20px; margin-right: 10px"
                                    name="is_teacher" type="checkbox" <?php if($data?->role == config('dummy.user.role.teacher')): echo 'checked'; endif; ?>>
                                <label for="role" style="text-align: left;">Check the box if this user is a <b>Training Portal</b></label>
                            </div>
                        </div>
                    
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label><?php echo app('translator')->get('user.form.profile.label'); ?></label>
                        <div class="form-select-photo image">
                            <div class="select-photo <?php echo request('id') && isset($data) && $data->profile != null ? 'active' : ''; ?>">
                                <div class="icon">
                                    <i data-feather="image"></i>
                                </div>
                                <div class="title">
                                    <span><?php echo app('translator')->get('user.form.profile.placeholder'); ?></span>
                                </div>
                            </div>
                            <div class="image-view <?php echo request('id') && isset($data) && $data->profile != null ? 'active' : ''; ?>">
                                <img src="<?php echo request('id') && isset($data) && $data->profile != null ? asset('file_manager' . $data->profile) : null; ?>"
                                    onerror="(this).src='<?php echo e(asset('images/logo/default.png')); ?>'" alt="">
                            </div>
                            <input type="text" name="image" s-click-fn="selectImage(event)" autocomplete="off"
                                role="presentation">
                            <input type="hidden" name="tmp_file" value="<?php echo request('id') && isset($data) && $data->profile != null ? $data->profile : ''; ?>">
                        </div>
                        <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="form-button">
                    <button type="submit" color="primary">
                        <i data-feather="save"></i>
                        <span><?php echo app('translator')->get('user.form.button.submit'); ?></span>
                    </button>
                    <button color="danger" type="button" s-click-link="<?php echo route('admin-user-list', 1); ?>">
                        <i data-feather="x"></i>
                        <span><?php echo app('translator')->get('user.form.button.cancel'); ?></span>
                    </button>
                </div>
            </div>
            <div class="form-footer"></div>
        </form>
    </div>
    <?php echo $__env->make('admin::file-manager.popup', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script lang="ts">
        $(document).ready(function() {
            $validator("#form", {
                name: {
                    required: true,
                },
                phone: {
                    required: true,
                },
                email: {
                    required: true,
                    email: true,
                },
                <?php if(!request('id')): ?>
                    password: {
                        required: true,
                    },
                    confirm_password: {
                        required: true,
                        match: "password"
                    },
                <?php endif; ?>
                branch_id: {
                    required: true,
                },
                status: {
                    required: true,
                },
            });
        });

        function selectImage(e) {
            fileManager({
                multiple: false,
                afterClose: (data, basePath) => {
                    if (data?.length > 0) {
                        const parent = e.target.closest('.form-select-photo');
                        e.target.value = data[0].path;
                        parent
                            .querySelector('.select-photo')
                            .classList.add('active');
                        parent
                            .querySelector('.image-view')
                            .classList
                            .add('active');
                        parent
                            .querySelector('.image-view')
                            .childNodes[0]
                            .nextElementSibling
                            .setAttribute('src', basePath + data[0].path);
                    }
                }
            })
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin::shared.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/user/create.blade.php ENDPATH**/ ?>