<?php $__env->startComponent('website::components.dialog', ['dialog' => 'courseDialog']); ?>
    <div class="pop-up" x-data="course">
        <div class="pop-up-wrapper">
            <div class="pop-up-close" @click="$store.courseDialog.close()">
                <i data-feather="x"></i>
            </div>
            <div class="modal-box show-modal">
                <div class="course-page-wrapper gap-x-8 gap-y-1">
                    <!-- register-content -->
                    <div class="course-page-wrapper-box p-2 register-content" id="register-content"
                        x-bind:style="isCourse ? 'display: block' : 'display: none'" style="margin-bottom: 0px">
                        <div class="course-content">
                            <div class="image-course w-1/2 ">
                                <img x-bind:src="path + dataDialog?.image" alt=""
                                    onerror="this.onerror=null;this.src='<?php echo e(asset('website/images/logo/default.png')); ?>';">
                                <div class="btn-register btn-auth">
                                    <button class="uppercase" @click="openRegisterDialog()">Register
                                        Now</button>
                                </div>
                            </div>
                            <div class="detail-course w-1/2 ">
                                <h2 x-text="dataDialog?.name"></h2>
                                <p x-text="dataDialog?.description"></p>
                                <div class="dates">
                                    <span class="flex flex-row space-x-2">
                                        <i class="fas fa-calendar-alt text-yellow-500"></i>
                                        <span x-text="moment(dataDialog?.date).format('DD/MM/YYYY')"></span>
                                    </span>
                                </div>
                                <div class="day mt-1">
                                    <span class="flex flex-row space-x-2">
                                        <i class="far fa-calendar-check"></i>
                                        <span x-text="dataDialog?.duration + ' day(s)'"></span>
                                    </span>
                                </div>
                                <div class="price mt-3">
                                    <h3 x-text="dataDialog?.fee"></h3>
                                </div>
                                <div class="btn-trainer" id="btn-trainer">
                                    <button class="uppercase" @click="switchToActive('trainer')">Trainer</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- detail-content -->
                    <div class="course-page-wrapper-box p-2 detail-content" id="switchToTrainer"
                        x-bind:style="isTrainer ? 'display: block' : 'display: none'">
                        <div class="course-content">
                            <div class="cart">
                                <div class="text-cart">
                                    <div class="title">
                                        <h4 class="text-yellow-600" x-text="dataDialog?.trainer?.name"></h4>
                                    </div>
                                    <div class="text">
                                        <div class="flex flex-col">
                                            <div class="flex flex-row space-x-2">
                                                <p>Experience: </p>
                                                <p x-text="dataDialog?.trainer?.experience + ' year(s)'"></p>
                                            </div>
                                        </div>
                                        <div class="flex flex-col">
                                            <div class="flex flex-row space-x-14">
                                                <p>Skill: </p>
                                                <p x-text="dataDialog?.trainer?.skill"></p>
                                            </div>
                                        </div>
                                        <div class="flex flex-col">
                                            <div class="flex flex-row space-x-12">
                                                <p>Work: </p>
                                                <p x-text="dataDialog?.trainer?.work"></p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="btn-trainer btn-course" id="btn-course">
                                        <button class="uppercase" @click="switchToActive('course')">Course</button>
                                    </div>
                                </div>
                            </div>
                            <div class="image-course w-1/2 ">
                                <img x-bind:src="path + dataDialog?.image" alt=""
                                    onerror="this.onerror=null;this.src='<?php echo e(asset('website/images/logo/default.png')); ?>';">
                                <div class="btn-register">
                                    <button class="uppercase" @click="openRegisterDialog()">Register Now</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        Alpine.data('course', () => ({
            loading: false,
            dataDialog: null,
            path: '<?php echo e(asset('file_manager')); ?>',
            isCourse: false,
            isTrainer: false,
            registerData: null,

            init() {
                this.isCourse = true;
                let data = this.$store.courseDialog.data;
                this.dataDialog = JSON.parse(data?.data);
                this.registerData = data?.data;
            },

            switchToActive(type) {
                this.isCourse = type === 'course' ? true : false;
                this.isTrainer = type === 'trainer' ? true : false;
            },

            openRegisterDialog() {
                this.$store.registerDialog.open({
                    data: {
                        data: this.registerData,
                    }
                })
            },
        }));
    </script>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/website/views/components/course-dialog.blade.php ENDPATH**/ ?>