<?php $__env->startSection('layout'); ?>
    <div class="form-admin" x-data="create_classes">
        <div class="form-bg"></div>
        <form id="form" class="form-wrapper" action="<?php echo route('admin-class-save', request('id')); ?>" method="POST" enctype="multipart/form-data">
            <div class="form-header">
                <h3>
                    <i data-feather="arrow-left" s-click-link="<?php echo route('admin-class-list', 1); ?>"></i>
                    <?php echo request('id') ? 'Update Class' : 'Create Class'; ?>

                </h3>
            </div>
            <?php echo e(csrf_field()); ?>

            <div class="form-body">
                <div class="row-2">
                    <div class="form-row">
                        <label>Select Class Type <span>*</span></label>
                        <select name="class_type_id">
                            <option value="">Select class type</option>
                            <?php $__currentLoopData = $class_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo $ct->id; ?>" <?php echo (request('id')
                                        ? ($ct->id == $data->class_type_id
                                            ? 'selected'
                                            : '')
                                        : old('class_type_id') == $ct->id)
                                    ? 'selected'
                                    : ''; ?>><?php echo $ct->name; ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['class_type_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error"><?php echo $message; ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-row">
                        <label>Select Class Level <span>*</span></label>
                        <select name="class_level_id">
                            <option value="">Select class level</option>
                            <?php $__currentLoopData = $class_level; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo $cl->id; ?>" <?php echo (request('id')
                                        ? ($cl->id == $data->class_level_id
                                            ? 'selected'
                                            : '')
                                        : old('class_level_id') == $cl->id)
                                    ? 'selected'
                                    : ''; ?>><?php echo $cl->name; ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['class_level_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error"><?php echo $message; ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>Select Class Status <span>*</span></label>
                        <select name="class_status_id">
                            <option value="">Select class status</option>
                            <?php $__currentLoopData = $class_status; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cs): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo $cs->id; ?>" <?php echo (request('id')
                                        ? ($cs->id == $data->class_status_id
                                            ? 'selected'
                                            : '')
                                        : old('class_status_id') == $cs->id)
                                    ? 'selected'
                                    : ''; ?>><?php echo $cs->name; ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['class_status_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error"><?php echo $message; ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-row">
                        <label>Select Shift <span>*</span></label>
                        <select name="shift_id">
                            <option value="">Select class shift</option>
                            <?php $__currentLoopData = $shift; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sh): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo $sh->id; ?>" <?php echo (request('id')
                                        ? ($sh->id == $data->shift_id
                                            ? 'selected'
                                            : '')
                                        : old('shift_id') == $sh->id)
                                    ? 'selected'
                                    : ''; ?>><?php echo $sh->name; ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['shift_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error"><?php echo $message; ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>Select Staff <span>*</span></label>
                        <select name="staff_id">
                            <option value="">Select staff</option>
                            <?php $__currentLoopData = $staff; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $st): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo $st->id; ?>" <?php echo (request('id')
                                        ? ($st->id == $data->staff_id
                                            ? 'selected'
                                            : '')
                                        : old('staff_id') == $st->id)
                                    ? 'selected'
                                    : ''; ?>><?php echo $st->full_name; ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['staff_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error"><?php echo $message; ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-row">
                        <label>Class Code <span>*</span></label>
                        <input type="text" name="class_code" value="<?php echo request('id') ? $data->class_code : old('class_code'); ?>" placeholder="Class Code" />
                        <?php $__errorArgs = ['class_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error"><?php echo $message; ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>Generation <span>*</span></label>
                        <input type="text" id="generation" name="generation" placeholder="Generation"
                            value="<?php echo request('id') ? $data->generation : old('generation'); ?>" />
                        <?php $__errorArgs = ['generation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error"><?php echo $message; ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-row">
                        <label>Group <span>*</span></label>
                        <input type="text" id="group" name="group" value="<?php echo request('id') ? $data->group : old('group'); ?>"
                            placeholder="Group">
                        <?php $__errorArgs = ['group'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error"><?php echo $message; ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>Period Duration (Day)<span>*</span></label>
                        <input type="text" id="duration" name="period_duration" placeholder="Period Duratioin"
                            value="<?php echo request('id') ? $data->period_duration : old('period_duration'); ?>" />
                        <?php $__errorArgs = ['period_duration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error"><?php echo $message; ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="row-2">
                        <div class="form-row">
                            <label>Start Date <span>*</span></label>
                            <input type="text" id="start_date" name="start_date" placeholder="Start Data"
                                value="<?php echo request('id') ? $data->start_date : old('start_date'); ?>" readonly>
                            <?php $__errorArgs = ['start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error"><?php echo $message; ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-row">
                            <label>End Date <span>*</span></label>
                            <input type="text" id="end_date" name="end_date" placeholder="End Date"
                                value="<?php echo request('id') ? $data->end_date : old('end_date'); ?>" readonly>
                            <?php $__errorArgs = ['end_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error"><?php echo $message; ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div> 
                <div class="row-3">
                    <div class="form-row">
                        <label>Class Cost </label>
                        <input @input="calcTotalCost()" type="text" name="class_cost" value="<?php echo request('id') ? $data->class_cost : old('class_cost'); ?>"
                            placeholder="0" id="class_cost">
                        <?php $__errorArgs = ['class_cost'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error"><?php echo $message; ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-row">
                        <label>Supplies Cost ($)</label>
                        <input @input="calcTotalCost()" type="text" name="supplies_cost" value="<?php echo request('id') ? $data->supplies_cost : old('supplies_cost'); ?>"
                            placeholder="0" id="supplies_cost">
                        <?php $__errorArgs = ['supplies_cost'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error"><?php echo $message; ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div> 
                    <div class="form-row">
                        <label>Total Cost ($)</label>
                        <input type="text" name="total_cost" value="<?php echo request('id') ? $data->total_cost : old('total_cost'); ?>"
                            placeholder="0" id="total_cost" readonly>
                        <?php $__errorArgs = ['total_cost'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error"><?php echo $message; ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div> 
                <div class="row">
                    <div class="form-row">
                        <label>URL Google Sheet Edit Embed ($)</label>
                        <textarea name="url_google_sheet_edit" placeholder="Enter Google Sheet link that can edit"><?php echo request('id') ? $data->url_google_sheet_edit : old('url_google_sheet_edit'); ?></textarea>
                        <?php $__errorArgs = ['url_google_sheet_edit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error"><?php echo $message; ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="row">
                    <div class="form-row">
                        <label>URL Google Sheet View Embed </label>
                        <textarea name="url_google_sheet_view" placeholder="Enter Google Sheet link that can view only"><?php echo request('id') ? $data->url_google_sheet_view : old('url_google_sheet_view'); ?></textarea>
                        <?php $__errorArgs = ['url_google_sheet_view'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error"><?php echo $message; ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="form-button">
                    <button type="submit" color="primary">
                        <i data-feather="save"></i>
                        <span>Submit</span>
                    </button>
                    <button color="danger" type="button" s-click-link="<?php echo route('admin-class-list', 1); ?>">
                        <i data-feather="x"></i>
                        <span>Cancel</span>
                    </button>
                </div>
            </div>
            <div class="form-footer"></div>
        </form>
    </div>
    <?php echo $__env->make('admin::file-manager.popup', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script lang="ts">
        Alpine.data('create_classes', () => ({
            init() {
                this.onKeyUp();
                if(!<?php echo json_encode(request('id'), 15, 512) ?>){
                    $('#total_cost').val(0);
                }
            },
            onKeyUp() {
                $('#group').keyup(function() {
                    this.value = this.value.replace(/[^0-9]/g, '');
                    if (this.value.length > 15) {
                        this.value = this.value.slice(0, 15);
                    }
                });
                $('#generation').keyup(function() {
                    this.value = this.value.replace(/[^0-9]/g, '');
                    if (this.value.length > 15) {
                        this.value = this.value.slice(0, 15);
                    }
                });
                $('#duration').keyup(function() {
                    this.value = this.value.replace(/[^0-9]/g, '');
                    if (this.value.length > 15) {
                        this.value = this.value.slice(0, 15);
                    }
                });
                $('#class_cost').keyup(function() {
                    this.value = this.value.replace(/[^0-9.]/g, '');
                    if (this.value.length > 15) {
                        this.value = this.value.slice(0, 15);
                    }
                    if (this.value < 0) {
                        this.value = 0;
                    }

                    // if typing dot more than 0 then add 0 before dot and remove dot after 2 number
                    if (this.value.split('.').length > 1) {
                        if (this.value.split('.')[0] == '') {
                            this.value = '0' + this.value;
                        }

                        this.value = this.value.split('.')[0] + '.' + this.value.split('.')[1]
                            .slice(0, 2);
                    }

                    // value as float
                    if (this.value.split('.').length > 0) {
                        if (this.value.split('.')[1]) {
                            this.value = this.value.split('.')[0] + '.' + this.value.split('.')[1]
                                .slice(0, 2);
                        }
                    }
                });
                $('#supplies_cost').keyup(function() {
                    this.value = this.value.replace(/[^0-9.]/g, '');
                    if (this.value.length > 15) {
                        this.value = this.value.slice(0, 15);
                    }
                    if (this.value < 0) {
                        this.value = 0;
                    }

                    // if typing dot more than 0 then add 0 before dot and remove dot after 2 number
                    if (this.value.split('.').length > 1) {
                        if (this.value.split('.')[0] == '') {
                            this.value = '0' + this.value;
                        }

                        this.value = this.value.split('.')[0] + '.' + this.value.split('.')[1]
                            .slice(0, 2);
                    }

                    // value as float
                    if (this.value.split('.').length > 0) {
                        if (this.value.split('.')[1]) {
                            this.value = this.value.split('.')[0] + '.' + this.value.split('.')[1]
                                .slice(0, 2);
                        }
                    }
                });
            },
            calcTotalCost(){
                let classCost = parseFloat($('#class_cost').val());
                if(classCost == '' || classCost == null){
                    classCost = 0;
                }
                let suppliesCost = parseFloat($('#supplies_cost').val());
                if(suppliesCost == '' || suppliesCost == null){
                    suppliesCost = 0;
                }
                if(isNaN(classCost) || isNaN(suppliesCost)){
                    if(isNaN(classCost) && !isNaN(suppliesCost)){
                        $('#total_cost').val(suppliesCost);
                    }else if(isNaN(suppliesCost) && !isNaN(classCost)){
                        $('#total_cost').val(classCost);
                    }else if(isNaN(suppliesCost) && isNaN(classCost)){
                        $('#total_cost').val(0);
                    }
                }else{
                    let totalCost = parseFloat(classCost) + parseFloat(suppliesCost);
                    $('#total_cost').val(totalCost);
                }
            }
        }));
        $(document).ready(function() {
            $validator("#form", {
                class_type_id: {
                    required: true,
                },
                class_level_id: {
                    required: true,
                },
                class_status_id: {
                    required: true,
                },
                shift_id: {
                    required: true,
                },
                staff_id: {
                    required: true,
                },
                class_code: {
                    required: true,
                },
                generation: {
                    required: true,
                },
                group: {
                    required: true,
                },
                period_duration: {
                    required: true,
                },
                start_date: {
                    required: true,
                },
                end_date: {
                    required: true,
                },
            });

            $("#start_date").datepicker({
                changeYear: true,
                gotoCurrent: true,
                yearRange: '-50:',
                dateFormat: "yy-mm-dd",
                onSelect: (select) => {
                    $('#end_date').datepicker('option', 'minDate', select)
                }
            });

            $("#end_date").datepicker({
                changeYear: true,
                gotoCurrent: true,
                yearRange: '-50:',
                dateFormat: "yy-mm-dd",
                minDate: $("#start_date").val(),
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin::shared.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/class/create.blade.php ENDPATH**/ ?>