<template x-if="toScore">
    <div class="classLogDialogLayout">
        <div class="classLogDialog p-3" style="width: 210mm;">
            <form id="to_score" class="h-100" method="POST"
                action="<?php echo e(route('admin-student-lesson-score-save', request('class_id'))); ?>"
                enctype="multipart/form-data">
                <?php echo e(csrf_field()); ?>

                <div>
                    <div class="d-flex justify-content-between">
                        <h3 class="mt-0">
                            <?php echo e(strtoupper('send exam to score')); ?>

                        </h3>
                        <span @click="dialogToScore()" class="btn-close cursor-pointer"></span>
                    </div>
                    <div class="mb-2">
                        <span>
                            <?php echo e(strtoupper('Select lesson to assign')); ?>

                        </span>
                        <span class="text-danger">*</span>
                    </div>
                    <select class="w-100 mb-2"
                        style="border: 1px solid #4f4f4f; border-radius: 5px;padding: 5px;color: #4f4f4f"
                        name="to_score_lesson" id="">
                        <option value="">Select...</option>
                        <?php $__currentLoopData = $lessons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lesson): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($lesson->id); ?>"><?php echo e($lesson->short_name); ?> | <?php echo e($lesson->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="table" style="height: 380px;">
                    <div class="table-wrapper" style="padding-bottom: 0;">
                        <div class="table-header bg-black">
                            <div class="row table-row-10">
                                <span class="text-light">Check</span>
                            </div>
                            <div class="row table-row-10">
                                <span class="text-light">N.</span>
                            </div>
                            <div class="row table-row-25">
                                <span class="text-light">SID</span>
                            </div>
                            <div class="row table-row-25">
                                <span class="text-light">Name</span>
                            </div>
                            <div class="row table-row-15">
                                <span class="text-light">ES Name</span>
                            </div>
                            <div class="row table-row-15">
                                <span class="text-light">Score</span>
                            </div>
                        </div>
                        <div class="table-body" style="height: calc(100% - 90px);">
                            <template x-if="exam_answer_sheet_on_exam_subject.length > 0">
                                <template x-for="(data, index) in exam_answer_sheet_on_exam_subject">
                                    <div class="column">
                                        <div class="row table-row-10">
                                            <input type="checkbox" :value="data.id" name="to_score_exam_as[]">
                                        </div>
                                        <div class="row table-row-10">
                                            <span x-text="index+1"></span>
                                        </div>
                                        <div class="row table-row-25">
                                            <span x-text="data.exam_candidate.student.sid"></span>
                                        </div>
                                        <div class="row table-row-25">
                                            <span x-text="data.exam_candidate.student.name_khmer"></span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span x-text="data.exam_subject.description"></span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span x-text="data.acquired_score"></span>
                                        </div>
                                    </div>
                                </template>
                            </template>
                        </div>
                    </div>
                </div>
                <template x-if="exam_answer_sheet_on_exam_subject.length > 0">
                <button class="bg-primary w-auto d-flex justify-content-end" style="border-radius: 4px;">
                    <span class="text-light">
                        បញ្ចូល
                    </span>
                </button>
                </template>
            </form>
        </div>
</template><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/examControl/examSubject/to-score.blade.php ENDPATH**/ ?>