<div id="exam-list" class="bg-white mb-3 mt-3">
    <div id="student-list" class="form-body p-3">
        <h2 class="mt-0">
            <?php echo strtoupper('Exam list'); ?>

        </h2>
        <div class="row d-flex justify-content-between align-items-center">
            <div>
                <div>
                    <span>
                        Result Count: <span class="text-primary"><?php echo e(count($data)); ?></span>
                    </span>
                </div>
                <div>
                    <span>
                        Class ID: <span class="text-primary"><?php echo e(request('class_id')); ?></span>
                    </span>
                </div>
            </div>
            <div>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam-control-create')): ?>
                <span class="h-50">
                    <button class="btn-create bg-primary h-100" @click="dialogOpenCreate()">
                        <span><?php echo strtoupper('add new exam to class'); ?></span>
                    </button>
                </span>
                <?php endif; ?>
            </div>
        </div>
        <div class="row">
            <div class="table">
                <div class="table-wrapper">
                    <div class="table-header bg-black text-light">
                        <div class="row table-row-5">
                            <span class="font-sm"><?php echo strtoupper('exam id'); ?></span>
                        </div>
                        <div class="row table-row-15">
                            <span class="font-sm"><?php echo strtoupper('exam date'); ?></span>
                        </div>
                        <div class="row table-row-10">
                            <span class="font-sm"><?php echo strtoupper('exam type'); ?></span>
                        </div>
                        <div class="row table-row-10">
                            <span class="font-sm"><?php echo strtoupper('duration'); ?></span>
                        </div>
                        <div class="row table-row-10">
                            <span class="font-sm"><?php echo strtoupper('candidate'); ?></span>
                        </div>
                        <div class="row table-row-15">
                            <span class="font-sm"><?php echo strtoupper('exam subject'); ?></span>
                        </div>
                        <div class="row table-row-15">
                            <span class="font-sm"><?php echo strtoupper('exam note'); ?></span>
                        </div>
                        <div class="row table-row-15">
                            <span class="font-sm"><?php echo strtoupper('class status'); ?></span>
                        </div>
                        <div class="row table-row-5">
                            <span class="font-sm"></span>
                        </div>
                    </div>
                    <div class="table-body overflow-visible">
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="column">
                            <div class="row table-row-5">
                                <span class="font-sm"><?php echo $item->id; ?></span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm"><?php echo date('Y-m-d', strtotime($item->exam_date)); ?></span>
                            </div>
                            <div class="row table-row-10">
                                <span class="font-sm"><?php echo $item->exam_type->name; ?></span>
                            </div>
                            <div class="row table-row-10">
                                <span class="font-sm"><?php echo $item->duration; ?> day(s)</span>
                            </div>
                            <div class="row table-row-10">
                                <span class="font-sm"><?php echo e(count($item->exam_candidates)); ?></span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm"><?php echo strtoupper('exam subject'); ?></span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm"><?php echo $item->noted; ?></span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm"><?php echo $item->classes->class_status->name; ?></span>
                            </div>
                            <div class="row table-row-5">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['exam-control-update', 'exam-control-delete', 'exam-control-view-info',
                                'exam-answer-sheet-create', ''])): ?>
                                <div class="dropdown">
                                    <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                                        data-mdb-toggle="dropdown" aria-expanded="false">
                                    </i>
                                    <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                        <?php if($item->status != 'trash'): ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['exam-control-view-info', 'exam-subject-view', 'exam-candidate-view'])): ?>
                                        <li>
                                            <a class="dropdown-item"
                                                @click="dialogExamDetail(<?php echo e($item->id); ?>, <?php echo e(request('class_id')); ?>)">
                                                <i data-feather="monitor"></i>
                                                <span>View Detail</span>
                                            </a>
                                        </li>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam-control-update')): ?>
                                        <li>
                                            <a class="dropdown-item" @click="dialogOpenUpdate(<?php echo e($item->id); ?>)">
                                                <i data-feather="edit"></i>
                                                <span>Edit</span>
                                            </a>
                                        </li>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam-control-destroy')): ?>
                                        <li>
                                            <a class="dropdown-item disable-btn" onclick="$onConfirmMessage(
                                                '<?php echo e(route('admin-exam-control-delete', $item->id)); ?>',
                                                '<?php echo app('translator')->get('dialog.msg.delete', ['name' => $item->noted]); ?>',
                                                {
                                                confirm: '<?php echo app('translator')->get('dialog.button.delete'); ?>',
                                                cancel: '<?php echo app('translator')->get('dialog.button.cancel'); ?>'
                                                }
                                                );">
                                                <i data-feather="trash-2"></i>
                                                <span>Delete</span>
                                            </a>
                                        </li>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam-candidate-print')): ?>
                                        <li>
                                            <a class="dropdown-item"
                                                s-click-link="<?php echo e(route('admin-printing-exam-candidate', ['class_id'=>request('class_id'), 'exam_id' => $item->id])); ?>">
                                                <i data-feather="printer"></i>
                                                <span>Print Exam Candidate</span>
                                            </a>
                                        </li>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam-answer-sheet-create')): ?>
                                        <li>
                                            <a class="dropdown-item"
                                                @click="dialogAddAnswerSheet(<?php echo e($item->id); ?>, <?php echo e(request('class_id')); ?>)">
                                                <i data-feather="file-text"></i>
                                                <span>Add Answer Sheet</span>
                                            </a>
                                        </li>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('exam-control-score-table')): ?>
                                        <li>
                                            <a class="dropdown-item" @click="onViewScoreTable(<?php echo e($item->id); ?>)">
                                                <i data-feather="table"></i>
                                                <span>Exam Score Table</span>
                                            </a>
                                        </li>
                                        <?php endif; ?>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/examControl/info/exam-list.blade.php ENDPATH**/ ?>