<?php $__env->startSection('layout'); ?>
<div class="form-admin">
    <div class="form-bg"></div>
    <form id="form" class="form-wrapper" action="<?php echo route('admin-staff-save', request('id')); ?>" method="POST"
        enctype="multipart/form-data">
        <div class="form-header">
            <h3>
                <i data-feather="arrow-left" s-click-link="<?php echo route('admin-staff-list', 1); ?>"></i>
                <?php echo request('id') ? "Update Staff" : "Create Staff"; ?>

            </h3>
        </div>
        <?php echo e(csrf_field()); ?>

        <div class="form-body">
            <div class="row-2">
                <div class="form-row">
                    <label>Staff Type <span>*</span></label>
                    <select name="staff_type_id">
                        <option value="">Please select staff type</option>
                        <?php $__currentLoopData = $staff_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo $value->id; ?>" <?php echo e(request('id') && $data->staff_type_id == $value->id ? 'selected': ''); ?>><?php echo $value->name; ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="form-row">
                    <label>Staff Position</label>
                    <select name="staff_position_id" id="">
                        <option value="">Please select staff position</option>
                        <?php $__currentLoopData = $staff_positions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $staff_position): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($staff_position->id); ?>"<?php echo e(request('id') && $data->staff_position_id == $staff_position->id ? 'selected': ''); ?>><?php echo e($staff_position->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <div class="row-2">
                <div class="form-row">
                    <label>Full Name<span>*</span> </label>
                    <input type="text" name="name" value="<?php echo request('id') ? $data->full_name : old('full_name'); ?>"
                        placeholder="Staff full name">
                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="error"><?php echo app('translator')->get("message.".$message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div class="form-row">
                    <label>Phone</label>
                    <input type="text" name="phone" value="<?php echo request('id') ? $data->phone : old('phone'); ?>"
                        data-old="<?php echo request('id') ? $data->phone : old('phone'); ?>" placeholder="Enter Phone"
                        autocomplete="off">
                    <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="error"><?php echo app('translator')->get("message.".$message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            <div class="row-2">
                <div class="form-row">
                    <label>Email</label>
                    <input type="email" name="email" value="<?php echo request('id') ? $data->email : old('email'); ?>"
                        placeholder="Email" autocomplete="off">
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="error"><?php echo app('translator')->get("message.".$message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div class="form-row">
                    <label>Gender<span>*</span> </label>
                    <select name="gender">
                        <option value="F" <?php echo (request('id') && $data->gender == "F") ? 'selected' : ''; ?>>Female
                        </option>
                        <option value="M" <?php echo (request('id') && $data->gender == "M") ? 'selected' : ''; ?>>Male
                        </option>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="form-row">
                    <label>Status<span>*</span></label>
                    <select name="status">
                        <option value="1" <?php echo (request('id') && $data->status == 1) || old('status') == 1 ? 'selected' :
                            ''; ?>>Active</option>
                        <option value="2" <?php echo (request('id') && $data->status == 2) || old('status') == 2 ? 'selected' :
                            ''; ?>>In Active</option>
                    </select>
                </div>
            </div>
            <div class="row">
                <div class="form-row">
                    <label>Note </label>
                    <textarea name="noted" placeholder=""><?php echo request('id') ? $data->noted : old('noted'); ?></textarea>
                    <?php $__errorArgs = ['noted'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="error"><?php echo app('translator')->get("message.".$message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            <div class="row-2">
                <div class="form-row">
                    <label>Profile</label>
                    <div class="form-select-photo image">
                        <div
                            class="select-photo <?php echo request('id') && isset($data) && $data->profile != null ? 'active' : ''; ?>">
                            <div class="icon">
                                <i data-feather="image"></i>
                            </div>
                            <div class="title">
                                <span>Profile</span>
                            </div>
                        </div>
                        <div
                            class="image-view <?php echo request('id') && isset($data) && $data->profile != null ? 'active' : ''; ?>">
                            <img src="<?php echo request('id') && isset($data) && $data->profile != null ? asset('file_manager' . $data->profile) : null; ?>"
                                onerror="(this).src='<?php echo e(asset('images/logo/default.png')); ?>'" alt="">
                        </div>
                        <input type="text" name="image" s-click-fn="selectImage(event)" autocomplete="off"
                            role="presentation">
                        <input type="hidden" name="tmp_file"
                            value="<?php echo request('id') && isset($data) && $data->profile != null ? $data->profile : ''; ?>">
                    </div>
                </div>
                
            </div>
            <div class="form-button">
                <button type="submit" color="primary">
                    <i data-feather="save"></i>
                    <span>Submit</span>
                </button>
                <button color="danger" type="button" s-click-link="<?php echo route('admin-staff-list', 1); ?>">
                    <i data-feather="x"></i>
                    <span>Cancel</span>
                </button>
            </div>
        </div>
        <div class="form-footer"></div>
    </form>
</div>
<?php echo $__env->make('admin::file-manager.popup', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script lang="ts">
    $(document).ready(function() {
            $validator("#form", {
                staff_type_id: {
                    required: true,
                },
                name: {
                    required: true,
                },
                gender: {
                    required: true,
                },
                status: {
                    required: true,
                },
            });
        });
        function selectImage(e) {
            fileManager({
                multiple: false,
                afterClose: (data, basePath) => {
                    if (data?.length > 0) {
                        const parent = e.target.closest('.form-select-photo');
                        e.target.value = data[0].path;
                        parent
                            .querySelector('.select-photo')
                            .classList.add('active');
                        parent
                            .querySelector('.image-view')
                            .classList
                            .add('active');
                        parent
                            .querySelector('.image-view')
                            .childNodes[0]
                            .nextElementSibling
                            .setAttribute('src', basePath + data[0].path);
                    }
                }
            })
        }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin::shared.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/staff/create.blade.php ENDPATH**/ ?>