<?php $__env->startSection('layout'); ?>
    <div class="form-admin" x-data="structureProgram">
        <div class="form-bg"></div>
        <form id="form" class="form-wrapper" action="<?php echo route('admin-structure-program-save', request('id')); ?>" method="POST" enctype="multipart/form-data">
            <div class="form-header">
                <h3>
                    <i data-feather="arrow-left" s-click-link="<?php echo route('admin-structure-program-list', 1); ?>"></i>
                    <?php echo request('id') ? 'Update Program Structure' : 'Create Program Structure'; ?>

                </h3>
            </div>
            <?php echo e(csrf_field()); ?>

            <div class="form-body">
                <div class="row">
                    <div class="form-row">
                        <label>Select Class Occupation <span>*</span></label>
                        <select name="class_occupation_id">
                            <option value="">Please select one of class occupation</option>
                            <?php $__currentLoopData = $class_occupations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class_occupation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo $class_occupation->id; ?>" <?php echo (request('id')
                                        ? ($class_occupation->id == $data->class_occupation_id
                                            ? 'selected'
                                            : '')
                                        : old('class_occupation_id') == $class_occupation->id)
                                    ? 'selected'
                                    : ''; ?>>
                                    <?php echo $class_occupation->name; ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['class_occupation_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error"><?php echo $message; ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="row">
                    <div class="form-row">
                        <label>Description</label>
                        <textarea name="description" placeholder="Description"><?php echo request('id') ? $data->description : old('description'); ?></textarea>
                        <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="error"><?php echo $message; ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="row">
                    <div class="form-row m-0">
                        <label>Select Lesson<span>*</span></label>
                        <input class="cursor-pointer" type="text" x-model="lesson_name"
                            placeholder="Please select lesson" readonly @click="selectLesson()">
                        <input type="hidden" name="lesson_id" id="lesson_id">
                    </div>
                </div>
                <div class="form-button">
                    <button type="submit" color="primary">
                        <i data-feather="save"></i>
                        <span>Submit</span>
                    </button>
                    <button color="danger" type="button" s-click-link="<?php echo route('admin-structure-program-list', 1); ?>">
                        <i data-feather="x"></i>
                        <span>Cancel</span>
                    </button>
                </div>
            </div>
            <div class="form-footer"></div>
        </form>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        Alpine.data('structureProgram', () => ({
            lesson_name: null,
            lesson_ids: [],
            old_lesson_ids: <?php echo json_encode(request('id') ? $data->lessons : [], 15, 512) ?>,
            init() {
                if (<?php echo json_encode(request('id'), 15, 512) ?>) {
                    this.old_lesson_ids.forEach(element => {
                        this.lesson_ids.push({
                            _id: element.id,
                            _title: element.name,
                            _description: element?.occupation?.name,
                        });
                    });
                    this.lesson_name = this.old_lesson_ids.map(element => element.name);
                    $('#lesson_id').val(this.lesson_ids.map(item => item._id));
                }
            },
            selectLesson() {
                SelectOption({
                    title: "Select Lesson",
                    placeholder: "Search Lesson",
                    multiple: true,
                    unselect: false,
                    selected: this.lesson_ids,
                    onReady: (callback_data) => { 
                        Axios({
                                url: "<?php echo e(route('admin-structure-program-lesson')); ?>",
                                method: 'GET'
                            })
                            .then(response => {
                                const data = response?.data?.data?.map(item => {
                                    return {
                                        _id: item.id,
                                        _title: item.name,
                                        _description: item?.occupation?.name,
                                        _time: 'PR: ' + item?.practice_hour + item
                                            .practice_duration_type + ', TH: ' + item
                                            ?.theory_hour + item.theory_duration_type,
                                    }
                                });
                                callback_data(data);
                            });
                    },
                    onSearch: (value, callback_data) => {
                        queueSearch = setTimeout(() => {
                            Axios({
                                    url: "<?php echo e(route('admin-structure-program-lesson')); ?>",
                                    params: {
                                        search: value,
                                    },
                                    method: 'GET'
                                })
                                .then(response => {
                                    const data = response?.data?.data?.map(
                                        item => {
                                            return {
                                                _id: item.id,
                                                _title: item.name,
                                                _description: item?.occupation
                                                    ?.name,
                                                _time: 'PR: ' + item
                                                    ?.practice_hour + item
                                                    .practice_duration_type +
                                                    ', TH: ' + item?.theory_hour +
                                                    item.theory_duration_type

                                            }
                                        });
                                    callback_data(data);
                                });
                        }, 1000);
                    },
                    afterClose: (res) => {
                        if (res?.length > 0) {
                            let data = res.map(item => {
                                return {
                                    _id: item._id,
                                    _title: item._title,
                                    _description: item._description
                                }
                            });
                            this.lesson_ids = data.map(item => item);
                            this.lesson_name = data.map(item => item._title);
                            $('#lesson_id').val(data.map(item => item._id));
                        }
                    }
                });
            },
        }));
        $(document).ready(function() {
            $validator("#form", {
                class_occupation_id: {
                    required: true,
                },
                lesson_id: {
                    required: true,
                },
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin::shared.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/structureProgram/create.blade.php ENDPATH**/ ?>