<?php $__env->startComponent('website::components.dialog', ['dialog' => 'partnerDialog']); ?>
    <div class="pop-up" x-data="partner">
        <div class="pop-up-wrapper">
            <div class="pop-up-close" @click="$store.partnerDialog.close()">
                <i data-feather="x"></i>
            </div>
            <div class="pop-up-body">
                <section>
                    <div class="partner-popup">
                        <div class="salon-section-block">
                            <div class="salon-section-block-control">
                                <div class="block-wrapper" style="padding: 10px 20px;">
                                    <div class="block-img w-1/4">
                                        <div class="text-over-img">
                                            <p>New</p>
                                        </div>
                                        <div class="fit-img">
                                            <img x-bind:src="path + dataDialog?.image" alt="" onerror="this.onerror=null;this.src='<?php echo e(asset('website/images/logo/default.png')); ?>';">
                                        </div>
                                        <img src="<?php echo e(asset('website/images/label-2.png')); ?>" alt="Photo" class="label">
                                        <div class="border-img"></div>
                                    </div>
                                    <div class="block-text w-3/4">
                                        <div class="title">
                                            <h4 x-text="dataDialog?.name"></h4>
                                            <div class="salon-info flex flex-col space-y-2">
                                                <div class="flex items-center">
                                                    <p>Tel</p>
                                                    <a>
                                                        : <span x-text="dataDialog?.phone"></span>
                                                    </a>
                                                </div>
                                                <div class="flex items-center">
                                                    <p>Facebook</p>
                                                    <a x-bind:href="dataDialog?.facebook" target="__blank">
                                                        : <span x-text="dataDialog?.facebook"></span>
                                                    </a>
                                                </div>
                                                <div class="flex items-center">
                                                    <p>Address</p>
                                                    <a>
                                                        : <span x-text="dataDialog?.address"></span>
                                                    </a>
                                                </div>
                                                <div class="flex items-center">
                                                    <p>Google Map</p>
                                                    <a x-bind:href="dataDialog?.google_map" target="__blank"
                                                        class="flex !overflow-hidden">
                                                        : <span class="subString-1 pl-1" x-text="dataDialog?.google_map"></span>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
    <script>
        Alpine.data('partner', () => ({
            loading: false,
            dataDialog: null,
            path: '<?php echo e(asset('file_manager')); ?>',

            init() {
                let data = this.$store.partnerDialog.data;
                this.dataDialog = JSON.parse(data?.data);
            },
        }));
    </script>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/website/views/components/partner-dialog.blade.php ENDPATH**/ ?>