<template x-if="$store.<?php echo e($dialog); ?>.show">
    <div x-data="<?php echo e($dialog); ?>_component" x-bind:style="{ zIndex: $store.libs.getLastIndex() + 1 }" class="dialog"
        x-bind:onload="dialogInit">
        <div class="dialog-wrapper">
            <div class="dialog-container">
                <?php echo e($slot); ?>

            </div>
        </div>
    </div>
</template>
<script>
    Alpine.data('<?php echo e($dialog); ?>_component', () => ({
        dialogInit() {
            feather.replace();
            const target = this.$root.querySelector('.dialog-container');
            this.$store.libs.playAnimateOnLoad(target);
            this.$store.<?php echo e($dialog); ?>.target = target;
        }
    }));
    Alpine.store('<?php echo e($dialog); ?>', {
        target: null,
        data: null,
        show: false,
        afterClosed: () => {},
        open(options) {
            this.data = options.data;
            this.afterClosed = options.afterClosed ?? null;
            this.show = true;
        },
        close(data = null) {
            Alpine.store('animate').leave(this.target, () => {
                this.show = false;
                if (typeof this.afterClosed === 'function') {
                    this.afterClosed(data);
                }
            });
        },
    });
</script>
<?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/components/dialog.blade.php ENDPATH**/ ?>