<template x-if="scoreTable">
    <div class="classLogDialogLayout">
        <div class="classLogDialog p-3 overflow-auto" style="width: 210mm;">
            <div class="h-100">
                <div>
                    <div class="d-flex justify-content-between">
                        <h3 class="mt-0">
                            <?php echo e(strtoupper('Exam Score Table')); ?>

                        </h3>
                        <span @click="onViewScoreTable()" class="btn-close cursor-pointer"></span>
                    </div>
                    <div class="d-flex">
                        <span class="font-weight-bold" style="margin-right: 20px;">Exam ID:</span>
                        <span x-text="scoreTableData.id"></span>
                        <span>|</span>
                        <span x-text="scoreTableData.exam_date_only"></span>
                        <span>|</span>
                        <span x-text="scoreTableData.exam_type.name"></span>
                    </div>
                    <template x-if="scoreTableData.exam_subjects.length > 0">
                        <template x-for="item in scoreTableData.exam_subjects">
                            <div>
                                <div class="d-flex text-primary">
                                    <h3 class="font-weight-bold mb-0">Subject:</h3>
                                    <h3 class="font-weight-light mb-0" x-text="item.description"
                                        style="margin-left: 20px;"></h3>
                                </div>
                                <div>
                                    <div class="table">
                                        <div class="table-wrapper">
                                            <div class="table-header bg-black">
                                                <div class="table-row-10 text-light">
                                                    <span class="font-sm font-weight-bold">N.</span>
                                                </div>
                                                <div class="table-row-25 text-light">
                                                    <span class="font-sm font-weight-bold"><?php echo e(strtoupper('Candidate
                                                        Name')); ?></span>
                                                </div>
                                                <div class="table-row-25 text-light">
                                                    <span class="font-sm font-weight-bold"><?php echo e(strtoupper('Lesson
                                                        name')); ?></span>
                                                </div>
                                                <div class="table-row-25 text-light">
                                                    <span class="font-sm font-weight-bold"><?php echo e(strtoupper('Sheet
                                                        issuer')); ?></span>
                                                </div>
                                                <div class="table-row-15 text-light">
                                                    <span
                                                        class="font-sm font-weight-bold"><?php echo e(strtoupper('score')); ?></span>
                                                </div>
                                            </div>
                                            <div class="table-body w-100 overflow-visible p-0">
                                                <template x-if="scoreTableData.exam_candidates.length > 0">
                                                    <template x-for="(data, index) in scoreTableData.exam_candidates">
                                                        <div class="column">
                                                            <div class="table-row-10">
                                                                <span style="font-size: 14px;" x-text="index+1"></span>
                                                            </div>
                                                            <div class="table-row-25">
                                                                <span style="font-size: 14px;"
                                                                    x-text="data.student.name_khmer"></span>
                                                            </div>
                                                            <div class="table-row-25">
                                                                <template x-for="eas in item.exam_answer_sheets">
                                                                    <template x-if="eas.exam_candidate_id == data.id">
                                                                        <template
                                                                            x-if="eas.student_lesson_score !== null">
                                                                            <span style="font-size: 14px;"
                                                                                x-text="eas.student_lesson_score.lesson.name"></span>
                                                                        </template>
                                                                    </template>
                                                                </template>
                                                            </div>
                                                            <div class="table-row-25">
                                                                <span style="font-size: 14px;"
                                                                    x-text="item.staff.full_name"></span>
                                                            </div>
                                                            <div class="table-row-15">
                                                                <template x-for="eas in item.exam_answer_sheets">
                                                                    <template x-if="eas.exam_candidate_id == data.id">
                                                                        <span style="font-size: 14px;"
                                                                            x-text="eas.acquired_score+','"></span>
                                                                    </template>
                                                                </template>
                                                            </div>
                                                        </div>
                                                    </template>
                                                </template>
                                                <template x-if="scoreTableData.exam_candidates.length <= 0">
                                                    <div class="column">
                                                        <div class="table-row-100" style="text-align: center;">
                                                            <span class="font-weight-bold text-danger">No Data!</span>
                                                        </div>
                                                    </div>
                                                </template>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </template>
                    </template>
                    
                </div>
            </div>
        </div>
</template><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/examControl/score-table.blade.php ENDPATH**/ ?>