<template x-if="structureProgram">
    <div class="classLogDialogLayout">
        <div class="classLogDialog p-4 overflow-auto" style="width: 90% !important">
            <div>
                <div class="d-flex justify-content-between mb-3">
                    <h2 class="m-0">
                        <?php echo strtoupper('Structure program detial'); ?>

                    </h2>
                    <span @click="openStructureProgram()" class="cursor-pointer btn-close">
                    </span>
                </div>
                <div class="row">
                    <div class="row border-1-gray p-4 mb-3">
                        <div class="row">
                            <h3 class="mt-0"><?php echo e(strtoupper('Structure Program')); ?></h3>
                        </div>
                        <div class="row-3">
                            <div class="form-row">
                                <span>
                                    Structure Program Id
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    <?php echo e($data->class_structure_program->structure_program->id ?? '--'); ?>

                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Occupation
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    <?php echo e($data->class_structure_program->structure_program->class_occupation->name ??
                                    '--'); ?>

                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Lesson count
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    <?php echo e(count($lessons)); ?>

                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="row border-1-gray p-4 mb-3">
                        <div class="row">
                            <h3 class="mt-0"><?php echo e(strtoupper('Lesson Information')); ?></h3>
                        </div>
                        <div class="row">
                            <div class="table">
                                <div class="table-wrapper p-0">
                                    <div class="table-header bg-black text-light">
                                        <div class="row table-row-10">
                                            <span class="font-sm"><?php echo strtoupper('N°'); ?></span>
                                        </div>
                                        <div class="row table-row-10">
                                            <span class="font-sm"><?php echo strtoupper('id'); ?></span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span class="font-sm"><?php echo strtoupper('occupation'); ?></span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span class="font-sm"><?php echo strtoupper('Short name'); ?></span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span class="font-sm"><?php echo strtoupper('full Name'); ?></span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span class="font-sm"><?php echo strtoupper('practice hour'); ?></span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span class="font-sm"><?php echo strtoupper('theory hour'); ?></span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span class="font-sm"><?php echo strtoupper('competency'); ?></span>
                                        </div>
                                    </div>
                                    <div class="table-body overflow-auto">
                                        <?php $__currentLoopData = $lessons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $lesson): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="column">
                                            <div class="row table-row-10">
                                                <span class="font-sm"><?php echo $index + 1; ?></span>
                                            </div>
                                            <div class="row table-row-10">
                                                <span class="font-sm"><?php echo $lesson->id ?? '--'; ?></span>
                                            </div>
                                            <div class="row table-row-15">
                                                <span class="font-sm"><?php echo $lesson->occupation-> name ?? '--'; ?></span>
                                            </div>
                                            <div class="row table-row-15">
                                                <span class="font-sm"><?php echo $lesson->short_name ?? '--'; ?></span>
                                            </div>
                                            <div class="row table-row-15">
                                                <span class="font-sm"><?php echo $lesson->name ?? '--'; ?></span>
                                            </div>
                                            <div class="row table-row-15">
                                                <span class="font-sm"><?php echo $lesson->practice_hour ?? '--'; ?></span>
                                            </div>
                                            <div class="row table-row-15">
                                                <span class="font-sm"><?php echo $lesson->theory_hour ?? '--'; ?></span>
                                            </div>
                                            <div class="row table-row-15">
                                                <span class="font-sm"><?php echo $lesson->competency_type ?? '--'; ?></span>
                                            </div>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row border-1-gray p-4 mb-3">
                        <div class="row">
                            <h3 class="mt-0"><?php echo e(strtoupper('class Information')); ?></h3>
                        </div>
                        <div class="row-3">
                            <div class="form-row">
                                <span>
                                    Class ID
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    <?php echo e($data->id ?? '--'); ?>

                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Class Code
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    <?php echo e($data->class_code ?? '--'); ?>

                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Trainer
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    <?php echo e($data->staff->full_name ?? '--'); ?>

                                </span>
                            </div>
                        </div>
                        <div class="row-3">
                            <div class="form-row">
                                <span>
                                    Class Status
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    <?php echo e($data->class_status->name ?? '--'); ?>

                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Class Level
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    <?php echo e($data->class_level->name ?? '--'); ?>

                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Class Type
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    <?php echo e($data->class_level->name ?? '--'); ?>

                                </span>
                            </div>
                        </div>
                        <div class="row-3">
                            <div class="form-row">
                                <span>
                                    Class Shift
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    <?php echo e($data->shift->name ?? '--'); ?>

                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Class Generation
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    <?php echo e($data->generation ?? '--'); ?>

                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Class Group
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    <?php echo e($data->group ?? '--'); ?>

                                </span>
                            </div>
                        </div>
                        <div class="row-3">
                            <div class="form-row">
                                <span>
                                    Class Start at
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    <?php echo e($data->start_date); ?>

                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Class Finish at
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    <?php echo e($data->end_date); ?>

                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Class Period
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    <?php echo e($data->period_duration ?? '--'); ?>

                                </span>
                            </div>
                        </div>
                        <div class="row-3">
                            <div class="form-row">
                                <span>
                                    Google Sheet (View)
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    <a href="<?php echo e($data->url_google_sheet_view ?? '#'); ?>" target="_blank">
                                        Visit
                                    </a>
                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Google Sheet (Edit)
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    <a href="<?php echo e($data->url_google_sheet_edit ?? '#'); ?>" target="_blank">
                                        Visit
                                    </a>
                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Total Student
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    <?php echo e(count($data->students)); ?>

                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="row border-1-gray p-4 mb-4">
                        <div class="row">
                            <h3 class="mt-0">
                                <?php echo e(strtoupper('Student In Class')); ?>

                            </h3>
                        </div>
                        <div class="row">
                            <div class="table">
                                <div class="table-wrapper">
                                    <div class="table-header bg-black text-light">
                                        <div class="row table-row-10">
                                            <span class="font-sm"><?php echo strtoupper('STU. ID'); ?></span>
                                        </div>
                                        <div class="row table-row-20">
                                            <span class="font-sm"><?php echo strtoupper('Student name KH'); ?></span>
                                        </div>
                                        <div class="row table-row-20">
                                            <span class="font-sm"><?php echo strtoupper('student name'); ?></span>
                                        </div>
                                        <div class="row table-row-13">
                                            <span class="font-sm"><?php echo strtoupper('Tel.'); ?></span>
                                        </div>
                                        <div class="row table-row-10">
                                            <span class="font-sm"><?php echo strtoupper('Gender'); ?></span>
                                        </div>
                                        <div class="row table-row-12">
                                            <span class="font-sm"><?php echo strtoupper('Date of Birth'); ?></span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span class="font-sm"><?php echo strtoupper('other'); ?></span>
                                        </div>
                                    </div>
                                    <div class="table-body overflow-auto">
                                        <?php $__currentLoopData = $data->students->sortBy('id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="column">
                                            <div class="row table-row-10">
                                                <span class="font-sm"><?php echo $student->id ?? '--'; ?></span>
                                            </div>
                                            <div class="row table-row-20">
                                                <span class="font-sm"><?php echo $student->name_khmer ?? '--'; ?></span>
                                            </div>
                                            <div class="row table-row-20">
                                                <span class="font-sm"><?php echo $student->name_latin ?? '--'; ?></span>
                                            </div>
                                            <div class="row table-row-13">
                                                <span class="font-sm"><?php echo $student->phone ?? '--'; ?></span>
                                            </div>
                                            <div class="row table-row-10">
                                                <span class="font-sm"><?php echo $student->gender ?? '--'; ?></span>
                                            </div>
                                            <div class="row table-row-12">
                                                <span class="font-sm"><?php echo $student->dob ?? '--'; ?></span>
                                            </div>
                                            <div class="row table-row-15">
                                                <span class="font-sm"><?php echo $student->noted ?? '--'; ?></span>
                                            </div>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</template><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/class/view-info/modal/view-structure-program.blade.php ENDPATH**/ ?>