<?php $__env->startSection('layout'); ?>
<div class="content-wrapper" x-data="StructureProgram">
    <div class="header">
        <?php echo $__env->make('admin::shared.header', ['header_name' => 'Program Structure Management'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="header-tab">
            <div class="header-tab-wrapper">
                <div class="menu-row">
                    <div class="menu-item <?php echo Request::is('admin/structure-program/list/1') ? 'active' : ''; ?>"
                        s-click-link="<?php echo route('admin-structure-program-list', 1); ?>">
                        All</div>
                </div>
            </div>
            <div class="header-action-button">
                <form class="filter" action="<?php echo url()->current(); ?>" method="GET">
                    <div class="form-row">
                        <input type="text" name="search" placeholder="Search" value="<?php echo request('search'); ?>">
                        <i data-feather="filter"></i>
                    </div>
                    <button mat-flat-button type="submit" class="btn-create bg-success">
                        <i data-feather="search"></i>
                        <span>Search</span>
                    </button>
                </form>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('structure-program-create')): ?>
                <button class="btn-create" s-click-link="<?php echo route('admin-structure-program-create'); ?>">
                    <i data-feather="plus-circle"></i>
                    <span>Create Structure Program</span>
                </button>
                <?php endif; ?>
                <button s-click-link="<?php echo url()->current(); ?>">
                    <i data-feather="refresh-ccw"></i>
                    <span>Reload</span>
                </button>
            </div>
        </div>
    </div>
    <div class="content-body">
        <?php echo $__env->make('admin::pages.structureProgram.table', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <template x-if="confirm">
            <div class="swal2-container swal2-center swal2-backdrop-show" style="overflow-y: auto;">
                <div aria-labelledby="swal2-title" aria-describedby="swal2-content"
                    class="swal2-popup swal2-modal confirm-message swal2-icon-warning swal2-show" tabindex="-1"
                    role="dialog" aria-live="assertive" aria-modal="true" style="display: flex;">
                    <div class="swal2-header">
                        <ul class="swal2-progress-steps" style="display: none;"></ul>
                        <div class="swal2-icon swal2-warning swal2-icon-show" style="display: flex;">
                            <div class="swal2-icon-content">!</div>
                        </div><img class="swal2-image" style="display: none;">
                        <h2 class="swal2-title" id="swal2-title" style="display: none;"></h2><button type="button"
                            class="swal2-close" aria-label="Close this dialog" style="display: none;">×</button>
                    </div>
                    <div class="swal2-content">
                        <div id="swal2-content" class="swal2-html-container" style="display: block;">
                            Are you sure to remove structured program with id <span class="text-danger"
                                x-text="id"></span> from
                            class with id <span class="text-danger" x-text="class_id"></span>
                        </div>
                        <input class="swal2-input" style="display: none;">
                        <input type="file" class="swal2-file" style="display: none;">
                        <div class="swal2-range" style="display: none;"><input type="range"><output></output>
                        </div><select class="swal2-select" style="display: none;"></select>
                        <div class="swal2-radio" style="display: none;"></div><label for="swal2-checkbox"
                            class="swal2-checkbox" style="display: none;"><input type="checkbox"><span
                                class="swal2-label"></span></label><textarea class="swal2-textarea"
                            style="display: none;"></textarea>
                        <div class="swal2-validation-message" id="swal2-validation-message" style="display: none;">
                        </div>
                    </div>
                    <br />
                    <div class="swal2-content">
                        <div id="swal2-content" class="swal2-html-container"
                            style="display: block; text-align: initial;">
                            <label for="status">Remove Students From Class</label>
                            <input id="status" type="checkbox" name="status" x-model="status" value="true"
                                style="width: 20px; height: 20px;">
                        </div>
                    </div>
                    <div class="swal2-actions">
                        <div class="swal2-loader"></div>
                        <button type="button" class="swal2-confirm swal2-styled" aria-label=""
                            style="display: inline-block;" @click="removeStructureFromClass()">
                            Remove
                        </button>
                        <button type="button" class="swal2-cancel swal2-styled" aria-label=""
                            style="display: inline-block;" @click="onConfirmMessage()">
                            Cancel
                        </button>
                    </div>
                    <div class="swal2-footer" style="display: none;"></div>
                    <div class="swal2-timer-progress-bar-container">
                        <div class="swal2-timer-progress-bar" style="display: none;"></div>
                    </div>
                </div>
            </div>
        </template>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    Alpine.data('StructureProgram', () => ({
        confirm: false,
        id: null,
        class_id: null,
        status: null,
        onConfirmMessage(id, class_id){
            if(this.confirm == false){
                this.confirm = true;
                this.id = id;
                this.class_id = class_id;
            }else{
                this.confirm = false;
            }
        },
        async removeStructureFromClass(){
            await Axios({
                url: `<?php echo e(route('admin-structure-program-remove-from-class')); ?>`,
                method: 'POST',
                params: {
                    'id': this.id, 
                    'status': this.status,
                },
            }).then((response)=>{
                if (response.data.code == 20000) {
                    this.createStudyNote = false;
                    window.location.reload();
                    Toast({
                        title: 'Success Message',
                        message: response.data.message,
                        status: 'success',
                        duration: 5000,
                    });
                }else{
                    Toast({
                        title: 'Warning Message',
                        message: response.data.message,
                        status: 'warning',
                        duration: 5000,
                    });
                }
            }).catch((err)=> {
                Toast({
                    title: 'Warning Message',
                    message: "Invalided value",
                    status: 'warning',
                    duration: 5000,
                });
            });
        }
    }));
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin::shared.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/structureProgram/index.blade.php ENDPATH**/ ?>