<?php $__env->startSection('layout'); ?>
<div class="form-admin">
    <div class="form-bg"></div>
    <form id="form" class="form-wrapper" action="<?php echo route('admin-class-image-save', request('class_id')); ?>"
        method="POST" enctype="multipart/form-data">
        <div class="form-header">
            <h3>
                <i data-feather="arrow-left"
                    s-click-link="<?php echo route('admin-class-image-list', request('class_id')); ?>"></i>
                Add New Class Image
            </h3>
        </div>
        <?php echo e(csrf_field()); ?>

        <div class="form-body">
            <div class="row-2">
                <div class="form-row">
                    <label><?php echo app('translator')->get('user.form.profile.label'); ?></label>
                    <div class="form-select-photo image">
                        <div
                            class="select-photo <?php echo request('id') && isset($data) && $data->profile != null ? 'active' : ''; ?>">
                            <div class="icon">
                                <i data-feather="image"></i>
                            </div>
                            <div class="title">
                                <span><?php echo app('translator')->get('user.form.profile.placeholder'); ?></span>
                            </div>
                        </div>
                        <div
                            class="image-view <?php echo request('id') && isset($data) && $data->profile != null ? 'active' : ''; ?>">
                            <img src="<?php echo request('id') && isset($data) && $data->profile != null ? asset('file_manager' . $data->profile) : null; ?>"
                                onerror="(this).src='<?php echo e(asset('images/logo/default.png')); ?>'" alt="">
                        </div>
                        <input type="text" name="image" s-click-fn="selectImage(event)" autocomplete="off"
                            role="presentation">
                        <input type="hidden" name="tmp_file"
                            value="<?php echo request('id') && isset($data) && $data->profile != null ? $data->profile : ''; ?>">
                    </div>
                </div>
                <div>
                    <div class="form-row">
                        <label>Class ID <span>*</span></label>
                        <div class="w-100 border-1-gray d-flex align-items-center"
                            style="height: 40px; padding: 0 15px; border-radius: 4px; color: #5a5e66;">
                            <?php echo e(request('class_id')); ?>

                        </div>
                    </div>
                    <div class="form-row">
                        <label>Image Date <span>*</span></label>
                        <input type="date" name="image_date">
                        <?php $__errorArgs = ['image_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <?php echo e($message); ?>

                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-row">
                        <label>Image Description</label>
                        <textarea name="description" placeholder="Please descript something"></textarea>
                        <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <?php echo e($message); ?>

                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>
            <div class="form-button">
                <button type="submit" color="primary">
                    <i data-feather="save"></i>
                    <span><?php echo app('translator')->get('user.form.button.submit'); ?></span>
                </button>
                <button color="danger" type="button" s-click-link="<?php echo e(route('admin-class-image-list', request('class_id'))); ?>">
                    <i data-feather="x"></i>
                    <span><?php echo app('translator')->get('user.form.button.cancel'); ?></span>
                </button>
            </div>
        </div>
        <div class="form-footer"></div>
    </form>
</div>
<?php echo $__env->make('admin::file-manager.popup', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script lang="ts">
    $(document).ready(function() {
        $validator("#form", {
            image: {
                required: true,
            },
            image_date: {
                required: true,
            },
        });
    });
    function selectImage(e) {
        fileManager({
            multiple: false,
            afterClose: (data, basePath) => {
                if (data?.length > 0) {
                    const parent = e.target.closest('.form-select-photo');
                    e.target.value = data[0].path;
                    parent
                        .querySelector('.select-photo')
                        .classList.add('active');
                    parent
                        .querySelector('.image-view')
                        .classList
                        .add('active');
                    parent
                        .querySelector('.image-view')
                        .childNodes[0]
                        .nextElementSibling
                        .setAttribute('src', basePath + data[0].path);
                }
            }
        })
    }  
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin::shared.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/class/classImage/create.blade.php ENDPATH**/ ?>