<div class="table">
    <?php if($data->count() > 0): ?>
        <div class="table-wrapper">
            <div class="table-header">
                <div class="row table-row-5">
                    <span><?php echo app('translator')->get('table.field.no'); ?></span>
                </div>
                <div class="row table-row-15">
                    <span>Branch</span>
                </div>
                <div class="row table-row-10">
                    <span><?php echo app('translator')->get('table.field.profile'); ?></span>
                </div>
                <div class="row table-row-20">
                    <span><?php echo app('translator')->get('table.field.name'); ?></span>
                </div>
                <div class="row table-row-15">
                    <span><?php echo app('translator')->get('table.field.email'); ?></span>
                </div>
                <div class="row table-row-10">
                    <span><?php echo app('translator')->get('table.field.phone'); ?></span>
                </div>
                <div class="row table-row-10">
                    <span><?php echo app('translator')->get('table.field.role'); ?></span>
                </div>
                <div class="row table-row-10">
                    <span><?php echo app('translator')->get('table.field.created_at'); ?></span>
                </div>
                <div class="row table-row-5">
                    <span></span>
                </div>
            </div>
            <div class="table-body">
                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="column h-auto">
                        <div class="row table-row-5">
                            <span><?php echo $data->currentPage() * $data->perPage() - $data->perPage() + ($index + 1); ?></span>
                        </div>
                        <div class="row table-row-15">
                            <span><?php echo isset($item->branch->name) ? $item->branch->name : '--'; ?></span>
                        </div>
                        <div class="row table-row-10">
                            <div class="thumbnail profile" data-fancybox
                                data-src="<?php echo e(asset('file_manager' . $item->profile)); ?>">
                                <img src="<?php echo $item->profile != null ? asset('file_manager' . $item->profile) : asset('images/logo/default.png'); ?>"
                                    onerror="(this).src='<?php echo e(asset('images/logo/default.png')); ?>'" alt="">
                            </div>
                        </div>
                        <div class="row table-row-20 text bold">
                            <span><?php echo isset($item->username) ? $item->username : '--'; ?></span>
                        </div>
                        <div class="row table-row-15 text">
                            <span><?php echo isset($item->email)
                                ? substr($item->email, 0, 3) . '****' . substr($item->email, strpos($item->email, '@'))
                                : '--'; ?></span>
                        </div>
                        <div class="row table-row-10 text">
                            <span><?php echo isset($item->phone) ? substr($item->phone, 0, 3) . '****' . substr($item->phone, -3) : '--'; ?></span>
                        </div>
                        <div class="row table-row-10">
                            <span style="text-transform: capitalize"><?php echo isset($item->role) ? $item->role : '--'; ?></span>
                        </div>
                        <div class="row table-row-10">
                            <?php $__currentLoopData = DateFormat::create($item->created_at); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span><?php echo $date; ?></span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="row table-row-5">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['user-update', 'user-delete'])): ?>
                                <div class="dropdown">
                                    <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                                        data-mdb-toggle="dropdown" aria-expanded="false">
                                    </i>
                                    <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user-update')): ?>
                                            <li>
                                                <a class="dropdown-item" s-click-link="<?php echo route('admin-user-create', $item->id); ?>">
                                                    <i data-feather="edit"></i>
                                                    <span><?php echo app('translator')->get('table.option.edit'); ?></span>
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" s-click-link="<?php echo route('admin-user-change-password', $item->id); ?>">
                                                    <i data-feather="key"></i>
                                                    <span><?php echo app('translator')->get('table.option.change_password'); ?></span>
                                                </a>
                                            </li>
                                            <?php if($item->id != Auth::user()->id): ?>
                                                <?php if($item->role == config('dummy.user.role.admin') || $item->role == config('dummy.user.role.teacher')): ?>
                                                    <li>
                                                        <a class="dropdown-item" s-click-link="<?php echo route('admin-user-permission', $item->id); ?>">
                                                            <i data-feather="sliders"></i>
                                                            <span><?php echo app('translator')->get('table.option.permission'); ?></span>
                                                        </a>
                                                    </li>
                                                <?php endif; ?>
                                                <?php if($item->status == 2): ?>
                                                    <li>
                                                        <a class="dropdown-item enable-btn"
                                                            onclick="$onConfirmMessage(
                                                                    '<?php echo route('admin-user-status', ['id' => $item->id, 'status' => 1]); ?>',
                                                                    '<?php echo app('translator')->get('dialog.msg.enable', ['name' => $item->name]); ?>',
                                                                    {
                                                                        confirm: '<?php echo app('translator')->get('dialog.button.enable'); ?>',
                                                                        cancel: '<?php echo app('translator')->get('dialog.button.cancel'); ?>'
                                                                    },
                                                                );">
                                                            <i data-feather="rotate-ccw"></i>
                                                            <span><?php echo app('translator')->get('table.option.enable'); ?></span>
                                                        </a>
                                                    </li>
                                                <?php else: ?>
                                                    <li>
                                                        <a class="dropdown-item disable-btn"
                                                            onclick="$onConfirmMessage(
                                                                    '<?php echo route('admin-user-status', ['id' => $item->id, 'status' => 2]); ?>',
                                                                    '<?php echo app('translator')->get('dialog.msg.disable', ['name' => $item->name]); ?>',
                                                                    {
                                                                        confirm: '<?php echo app('translator')->get('dialog.button.disable'); ?>',
                                                                        cancel: '<?php echo app('translator')->get('dialog.button.cancel'); ?>'
                                                                    }
                                                                );">
                                                            <i data-feather="x-circle"></i>
                                                            <span><?php echo app('translator')->get('table.option.disable'); ?></span>
                                                        </a>
                                                    </li>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>
            <div class="table-footer">
                <?php echo $__env->make('admin::components.pagination', ['paginate' => $data], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    <?php else: ?>
        <?php $__env->startComponent('admin::components.empty', [
            'name' => __('user.empty.title'),
            'msg' => __('user.empty.description'),
            'permission' => 'user-create',
            'url' => route('admin-user-create'),
            'button' => __('user.button.create'),
        ]); ?>
        <?php echo $__env->renderComponent(); ?>
    <?php endif; ?>
</div>
<?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/user/table.blade.php ENDPATH**/ ?>