<div class="table">
    <?php if($data->count() > 0): ?>
        <div class="table-wrapper">
            <div class="table-header">
                <div class="row table-row-10">
                    <span>Pro. Detail ID</span>
                </div>
                <div class="row table-row-10">
                    <span>Lesson ID</span>
                </div>
                <div class="row table-row-25">
                    <span>Lesson Name</span>
                </div>
                <div class="row table-row-25">
                    <span>Lesson Occupation</span>
                </div>
                <div class="row table-row-15">
                    <span>Lesson Practice hrs</span>
                </div>
                <div class="row table-row-15">
                    <span>Lesson Theory hrs</span>
                </div>
            </div>
            <div class="table-body">
                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="column bg-primary text-light">
                        <div class="row table-row-30">
                            <span>
                                Structure Program ID: <?php echo $value->id ? $value->id : '--'; ?>

                            </span>
                        </div>
                        <div class="row table-row-30">
                            <span>
                                <?php if($value->class_occupation_id): ?>
                                    <?php $__currentLoopData = $class_occupations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class_occupation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($value->class_occupation_id == $class_occupation->id): ?>
                                            Program Occupation: <?php echo $class_occupation->name; ?>

                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <?php echo '--'; ?>

                                <?php endif; ?>
                            </span>
                        </div>
                        <div class="row table-row-30 text left">
                            <span>
                                Program Name: <?php echo $value->description ? $value->description : '--'; ?>

                            </span>
                        </div>
                        <div class="row table-row-10">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->any(['structure-program-assign', 'structure-program-destroy',
                                'structure-program-update', 'structure-program-unassign'])): ?>
                                <div class="dropdown">
                                    <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                                        data-mdb-toggle="dropdown" aria-expanded="false">
                                    </i>
                                    <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                        <?php if($value->status != 'trash'): ?>
                                            
                                            <?php if($value->class_structure_program): ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('structure-program-unassign')): ?>
                                                    <a class="dropdown-item enable-btn"
                                                        @click="onConfirmMessage(<?php echo e($value->id); ?>, <?php echo e($value->class_structure_program->class_id); ?>)">
                                                        <i data-feather="rotate-ccw"></i>
                                                        <span>Remove From Class</span>
                                                    </a>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('structure-program-update')): ?>
                                                    <li>
                                                        <a class="dropdown-item" s-click-link="<?php echo route('admin-structure-program-create', $value->id); ?>">
                                                            <i data-feather="edit"></i>
                                                            <span>Edit</span>
                                                        </a>
                                                    </li>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('structure-program-assign')): ?>
                                                    <li>
                                                        <a class="dropdown-item" s-click-link="<?php echo route('admin-structure-program-assign-class', $value->id); ?>">
                                                            <i data-feather="edit"></i>
                                                            <span>Assign to Class</span>
                                                        </a>
                                                    </li>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('structure-program-destroy')): ?>
                                                    <li>
                                                        <a class="dropdown-item enable-btn"
                                                            onclick="$onConfirmMessage(
                                                                '<?php echo route('admin-structure-program-delete', $value->id); ?>',
                                                                'Are you sure to remove structured program with id <?php echo $value->id; ?>',
                                                                {
                                                                    confirm: 'Remove',
                                                                    cancel: '<?php echo app('translator')->get('dialog.button.cancel'); ?>'
                                                                },
                                                            );">
                                                            <i data-feather="rotate-ccw"></i>
                                                            <span>Remove</span>
                                                        </a>
                                                    </li>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php $__currentLoopData = $value->lesson_id; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $__currentLoopData = $lessons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lesson): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($item == $lesson->id): ?>
                                <div class="column">
                                    <div class="row table-row-10">
                                        <span>
                                            <?php echo $value->id; ?>

                                        </span>
                                    </div>
                                    <div class="row table-row-10">
                                        <span>
                                            <?php echo $lesson->id; ?>

                                        </span>
                                    </div>
                                    <div class="row table-row-25">
                                        <span>
                                            <?php echo $lesson->name; ?>

                                        </span>
                                    </div>
                                    <div class="row table-row-25">
                                        <span>
                                            <?php $__currentLoopData = $lesson_occupations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lesson_occupation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($lesson->lesson_occupation_id == $lesson_occupation->id): ?>
                                                    <?php echo $lesson_occupation->name; ?>

                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </span>
                                    </div>
                                    <div class="row table-row-15">
                                        <span>
                                            <?php echo $lesson->practice_hour ? $lesson->practice_hour . ' ' . ($lesson->practice_duration_type ? $lesson->practice_duration_type : '') : ''; ?>

                                        </span>
                                    </div>
                                    <div class="row table-row-15">
                                        <span>
                                            <?php echo $lesson->theory_hour ? $lesson->theory_hour . ' ' . ($lesson->theory_duration_type ? $lesson->theory_duration_type : '') : ''; ?>

                                        </span>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="table-footer">
                <?php echo $__env->make('admin::components.pagination', ['paginate' => $data], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    <?php else: ?>
        <?php $__env->startComponent('admin::components.empty', [
            'name' => 'Structure Program is empty',
            'msg' => 'You can create a new Structure Program by clicking the button below.',
            'permission' => 'structure-program-create',
            'url' => route('admin-structure-program-create'),
            'button' => 'Create Structure Program',
        ]); ?>
        <?php echo $__env->renderComponent(); ?>
    <?php endif; ?>
</div>
<?php /**PATH /home/1051036.cloudwaysapps.com/bffmptmecd/public_html/resources/admin/views/pages/structureProgram/table.blade.php ENDPATH**/ ?>