@extends('shared.layout')
@section('content')
    <!-- Slide section -->
    @if (isset($slider) && count($slider) > 0)
        <div class="section-slide bg-black">
            <div class="swiper mySwiper">
                <div class="swiper-wrapper">
                    @foreach ($slider as $item)
                        <div class="swiper-slide">
                            <img src="{{ asset('file_manager' . $item?->image) }}" alt=""
                                onerror="this.onerror=null;this.src='{{ asset('website/images/logo/default.png') }}';">
                        </div>
                    @endforeach
                </div>
                <div class="swiper-pagination"></div>
            </div>
        </div>
    @endif

    <!-- Salon Partner -->
    @if (isset($partners) && count($partners) > 0)
        <div class="salon-section container">
            <div class="salon-section-wrapper text-center">
                <div class="border-wrapper">
                    <div class="border" style="border-bottom: 1px solid yellow"></div>
                    <h3 class="text-3xl text-yellow-500">SALON PARTNER</h3>
                    <div class="border" style="border-bottom: 1px solid yellow"></div>
                </div>
            </div>
            @if (isset($contact))
                <div class="salon-section-map">
                    <iframe src="{{ getMapEmbedSrc($contact?->google_map) }}" width="600" height="450"
                        style="border:0;" allowfullscreen="" loading="lazy"
                        referrerpolicy="no-referrer-when-downgrade"></iframe>
                </div>
            @endif
            <div class="salon-section-block">
                <div class="salon-section-block-control">
                    @foreach ($partners as $item)
                        <div class="block-wrapper" data-aos="fade-up" data-aos-duration="1000">
                            <div class="block-img w-1/4">
                                <div class="text-over-img">
                                    <p>New</p>
                                </div>
                                <div class="fit-img">
                                    <img src="{{ asset('file_manager' . $item?->image) }}" alt=""
                                        onerror="this.onerror=null;this.src='{{ asset('website/images/logo/default.png') }}';">
                                </div>
                                <img src="{{ asset('website/images/label-2.png') }}" alt="" class="label">
                                <div class="border-img"></div>
                            </div>
                            <div class="block-text w-3/4">
                                <div class="title">
                                    <h4>{{ $item?->name }}</h4>
                                    <div class="salon-info flex flex-col space-y-2">
                                        <div class="flex">
                                            <p>Tel</p>
                                            <span href="#">: {{ $item?->phone }}</span>
                                        </div>
                                        <div class="">
                                            <p>Facebook</p>
                                            <a href="#">: {{ $item?->facebook }}</a>
                                        </div>
                                        <div class="flex">
                                            <p>Address</p>
                                            <span>
                                                : {{ $item?->address }}
                                            </span>
                                        </div>
                                        <div class="flex">
                                            <p>Google Map</p>
                                            <a href="{{ $item?->google_map }}" target="__blank"
                                                class="overflow-hidden flex items-center">:
                                                <span class="subString-1 pl-1">
                                                    {{ $item?->google_map }}
                                                </span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="border-line" data-aos="fade-up" data-aos-duration="1000"></div>
                    @endforeach
                </div>

                @include('website::components.pagination', ['data' => $partners])
            </div>
        </div>
    @else
        @component('website::components.empty', [
            'title' => __('Empty Data'),
            'message' => __('No Data in this Page'),
            'image' => asset('images/empty.svg'),
            'style' => 'height: 300px; width: auto;',
        ])
        @endcomponent
    @endif
@stop
@section('script')
    <script>
        var swiper = new Swiper(".mySwiper", {
            effect: "fade",
            loop: true,
            speed: 1000,
            autoplay: {
                delay: 5000,
                disableOnInteraction: false,
            },
            pagination: {
                el: ".swiper-pagination",
                clickable: true,
            },
            grabCursor: true,
        });
    </script>
@stop
