@extends('shared.layout')
@section('content')
    <div class="container">
        @if (count($photos) > 0 || count($videos) > 0)

            <div class="grid">
                <!-- photo Album -->
                @if (isset($photos) && count($photos) > 0)
                    <div class="border-wrapper">
                        <div class="border" style="border-bottom: 1px solid yellow"></div>
                        <h3 class="text-3xl text-yellow-500 uppercase">Photo Albums</h3>
                        <div class="border" style="border-bottom: 1px solid yellow"></div>
                    </div>

                    <div class="photo-albums">
                        <div class="photo-albums-container">
                            @foreach ($photos as $item)
                                <div class="photo-albums-container-items" data-aos="fade-up" data-aos-duration="1000">
                                    <div class="background">
                                        <div class="background-img">
                                            <div class="border"></div>
                                            <div class="background-style">
                                                <div class="view-more">
                                                    <a href="{{ route('website-gallery-index-photo', $item?->id) }}">
                                                        View Photo
                                                    </a>
                                                </div>
                                            </div>

                                            <div class="item-img">
                                                <img src="{{ asset('file_manager' . $item?->cover) }}" alt=""
                                                    onerror="this.onerror=null;this.src='{{ asset('website/images/logo/default.png') }}';">
                                                <div class="gallery-btn">
                                                    <p>
                                                        {{ $item?->name }}
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="quantity">
                                        <p class="text-white">{{ $item->countGallery() }} Item(s)</p>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif

                <!-- Video Album -->
                @if (isset($videos) && count($videos) > 0)
                    <div class="border-wrapper video-title">
                        <div class="border" style="border-bottom: 1px solid yellow"></div>
                        <h3 class="text-3xl text-yellow-500 uppercase">Video Albums</h3>
                        <div class="border" style="border-bottom: 1px solid yellow"></div>
                    </div>
                    <div class="video-albums ">
                        <div class="video-albums-container">
                            @foreach ($videos as $item)
                                <div class="video-albums-container-items" data-aos="fade-up" data-aos-duration="1000">
                                    <div class="background">
                                        <div class="background-img">
                                            <div class="border"></div>
                                            <div class="background-style">
                                                <div class="video-play-background"></div>
                                                <div class="view-more">
                                                    <a href="{{ route('website-gallery-index-video', $item?->id) }}">
                                                        View video
                                                    </a>
                                                </div>
                                            </div>
                                            <div class="item-img">
                                                <img src="{{ asset('file_manager' . $item?->cover) }}" alt="" onerror="this.onerror=null;this.src='{{ asset('website/images/logo/default.png') }}';">
                                                <div class="title-video-play">
                                                    <h4 class="uppercase">
                                                        {{ $item?->name }}
                                                    </h4>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="quantity">
                                        <p class="text-white">{{ $item->countVideo() }} Video(s)</p>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>
        @else
            @component('website::components.empty', [
                'title' => __('Empty Data'),
                'message' => __('No Data in this Page'),
                'image' => asset('images/empty.svg'),
                'style' => 'height: 300px; width: auto;',
            ])
            @endcomponent
        @endif
    </div>
@stop
