@extends('shared.layout')
@section('content')
    <!-- Course -->
    @if (isset($courses) && count($courses) > 0)
        <div class="container course-page  bg-black" x-data="courseDialog">
            <div class="course-header-wrapper">
                <div class="border-wrapper">
                    <div class="border" style="border-bottom: 1px solid yellow"></div>
                    <h3 class="text-3xl text-yellow-500">Course</h3>
                    <div class="border" style="border-bottom: 1px solid yellow"></div>
                </div>
            </div>
            <div class="course-page-wrapper gap-x-8 gap-y-1 mt-5">
                <!-- register-content -->
                @foreach ($courses as $item)
                    <div class="course-page-wrapper-box p-2 register-content !w-full" id="register-content"
                        data-aos="fade-up" data-aos-duration="3000" x-data="{ show: true }">

                        <!-- course-content -->
                        <div class="course-content" x-show="show == true">
                            <div class="image-course w-1/2 ">
                                <img src="{{ asset('file_manager' . $item?->image) }}" alt=""
                                    onerror="this.onerror=null;this.src='{{ asset('website/images/logo/default.png') }}';">
                                <div class="btn-register">
                                    <button class="uppercase" @click="openRegisterDialog('{{ $item }}')">Register
                                        Now</button>
                                </div>
                            </div>
                            <div class="detail-course w-1/2 ">
                                <h2>
                                    {{ $item?->name }}
                                </h2>
                                <p>
                                    {{ $item?->description }}
                                </p>
                                <div class="dates mt-5">
                                    <span class="flex flex-row  space-x-2">
                                        <i class="fas fa-calendar-alt text-yellow-500"></i>
                                        <span>{{ date('d-M-Y', strtotime($item?->created_at)) }}</span>
                                    </span>
                                </div>
                                <div class="day mb-2">
                                    <span class="flex flex-row space-x-2">
                                        <i class="far fa-calendar-check"></i>
                                        <h6>{{ $item?->duration }} day(s)</h6>
                                    </span>
                                </div>
                                <div class="price">
                                    <h3>{{ $item?->fee }}</h3>
                                </div>
                                <div class="btn-trainer" id="btn-trainer">
                                    <button class="uppercase" @click="show = false">Trainer</button>
                                </div>
                            </div>
                        </div>

                        <!-- trainer-content -->
                        <div class="course-content" x-show="show == false">
                            <div class="cart mt-5">
                                <div class="text-cart">
                                    <div class="title">
                                        <h4 class="text-yellow-600">{{ optional($item?->trainer)?->name }}</h4>
                                    </div>
                                    <div class="text">
                                        <div class="flex flex-col">
                                            <div class="flex flex-row space-x-2">
                                                <p>Experience: </p>
                                                <p>{{ optional($item?->trainer)?->experience }} year(s)</p>
                                            </div>
                                        </div>
                                        <div class="flex flex-col">
                                            <div class="flex flex-row space-x-14">
                                                <p>Skill: </p>
                                                <p>{{ optional($item?->trainer)->skill }}</p>
                                            </div>
                                        </div>
                                        <div class="flex flex-col">
                                            <div class="flex flex-row space-x-12">
                                                <p>Work: </p>
                                                <p>{{ optional($item?->trainer)->work }}</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="btn-trainer btn-course" id="btn-course">
                                        <button class="uppercase" @click="show = true">Course</button>
                                    </div>
                                </div>
                            </div>
                            <div class="image-course w-1/2 ">
                                <img src="{{ asset('file_manager' . $item?->image) }}" alt="">
                                <div class="btn-register">
                                    <button class="uppercase" @click="openRegisterDialog('{{ $item }}')">Register
                                        Now</button>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            @include('website::components.register-dialog')
        </div>


        @include('website::components.pagination', ['data' => $courses])
    @else
        @component('website::components.empty', [
            'title' => __('Empty Data'),
            'message' => __('No data found for this search'),
            'image' => asset('images/empty.svg'),
            'style' => 'height: 300px; width: auto;',
        ])
        @endcomponent
    @endif

@stop
@section('script')
    <script>
        Alpine.data("courseDialog", () => ({
            isActive: 'course',

            switchToActive(type) {
                this.isActive = type
            },

            openRegisterDialog(data) {
                this.$store.registerDialog.open({
                    data: {
                        data: data
                    }
                })
            }
        }));
    </script>
@stop
