<div class="share-dialog" :class="{ 'active': shareDialog }" x-data="shareDialog">
    <div class="share-dialog-overlay" @click="toggleShareModal"></div>
    <div class="share-dialog-content">
        <header>
            <span>@lang('website.pages.share_to_social_media')</span>
            <div class="close" @click="toggleShareModal()">
                <i data-feather="x"></i>
            </div>
        </header>
        <div class="content" :class="{ 'active': shareDialog }">
            <p>@lang('website.pages.share_this_link_via')</p>
            <div class="icons">
                <a href="https://www.facebook.com/sharer/sharer.php?u={{ isset($link) ? $link : urlencode(Request::fullUrl()) }}"
                    target="_blank" class="facebook"
                    onclick="window.open(this.href, 'share-facebook','left=50,top=50,width=600,height=320,toolbar=0'); return false;">
                    <i class="fab fa-facebook-f"></i></a>
                <a href="https://telegram.me/share/url?url={{ isset($link) ? $link : urlencode(Request::fullUrl()) }}"
                    target="_blank" class="telegram"
                    onclick="window.open(this.href, 'share-telegram','left=50,top=50,width=600,height=320,toolbar=0'); return false;"
                    target="_blank"><i class="fa-brands fa-telegram"></i></a>
                <a href="http://www.twitter.com/share?url={{ isset($link) ? $link : urlencode(Request::fullUrl()) }}"
                    onclick="window.open(this.href, 'share-twitter','left=50,top=50,width=600,height=320,toolbar=0'); return false;"
                    target="_blank" class="twitter"><i class="fab fa-twitter"></i></a>
            </div>
            <p>@lang('website.pages.or_copy_the_link')</p>
            <div class="field">
                <i data-feather="link"></i>
                <input type="text" id="share-link" class="shareUrlToSocialMedia" readonly>
                <button class="copy" @click="copyToClipboard">@lang('website.pages.copy')</button>
            </div>
        </div>
    </div>
</div>
<script type="module">
    Alpine.data("shareDialog", () => ({
        copyToClipboard() {
            const el = document.createElement('textarea');
            el.value = $('#share-link').val();
            document.body.appendChild(el);
            el.select();
            document.execCommand('copy');
            document.body.removeChild(el);

            const field = document.querySelector('.field');
            const copy = document.querySelector('.copy');
            field.classList.add('active');
            copy.innerText = `@lang('website.pages.copied')`;
            setTimeout(() => {
                window.getSelection().removeAllRanges();
                field.classList.remove('active');
                copy.innerText = `@lang('website.pages.copy')`;
            }, 3000);
        }
    }));
</script>
