@extends('admin::shared.layout')
@section('layout')
<div class="form-admin">
    <div class="form-bg"></div>
    <form id="form" class="form-wrapper" action="{!! route('admin-trainer-save', request('id'))!!}" method="POST"
        enctype="multipart/form-data">
        <div class="form-header">
            <h3>
                Trainer
            </h3>
        </div>
        {{ csrf_field() }}
        <div class="form-body">
            <div class="row-2">
                <div class="form-row">
                    <label>Name<span>*</span></label>
                    <input type="text" name="name" placeholder=""
                        value="{!! request('id') ? $data->name : old('name') !!}">
                    @error('name')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
                <div class="form-row">
                    <label>Status<span>*</span></label>
                    <select name="status" id="">
                        <option value="1" {{request('id') && $data->status == 1 ? 'selected' : ''}}>Active</option>
                        <option value="1" {{request('id') && $data->status == 2 ? 'selected' : ''}}>Disable</option>
                    </select>
                    @error('title')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
            </div>
            <div class="row-2">
                <div class="form-row">
                    <label>Skill<span>*</span></label>
                    <input type="text" name="skill" placeholder="Management/Hair Artist"
                        value="{!! request('id') ? $data->skill : old('skill') !!}">
                    @error('skill')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
                <div class="form-row">
                    <label>Experience<span>*</span></label>
                    <input type="number" step="0.5" name="experience" placeholder="1.5"
                        value="{!! request('id') ? $data->experience : old('experience') !!}">
                    @error('experience')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
            </div>
            <div class="row-2">
                <div class="form-row">
                    <label>Work</label>
                    <input type="text" name="work" placeholder="Trainer/Co-Founder" autocomplete
                        value="{!! request('id') ? $data->work : old('work') !!}">
                    @error('work')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
                <div class="form-row">
                    <label>Position</label>
                    <select name="position" id="">
                        <option value="">Select position...</option>
                        <option value="trainer" {{request('id') && $data->position == 'trainer' ? 'selected' :
                            old('position')}}>Trainer</option>
                        <option value="professional" {{request('id') && $data->position == 'professional' ? 'selected' :
                            old('position')}}>Professional</option>
                    </select>
                    @error('position')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
            </div>
            <div class="row-2">
                <div class="form-row flex-row">
                    <label class="cursor-pointer" for="certified">Certified</label>
                    <input class="cursor-pointer" style="height: 20px; width: auto" type="checkbox" name="certified" id="certified" value="1"
                        {{request('id') && $data->certified == 1 ? 'checked' : ''}}>
                </div>
                <div class="form-row flex-row">
                    <label class="cursor-pointer" for="popular">Popular</label>
                    <input class="cursor-pointer" style="height: 20px; width: auto" type="checkbox" name="popular" id="popular" value="1"
                        {{request('id') && $data->popular == 1 ? 'checked' : ''}}>
                </div>
            </div>
            <div class="row-2">
                <div class="form-row">
                    <label>Image</label>
                    <div class="form-select-photo image">
                        <div
                            class="select-photo {!! request('id') && isset($data) && $data->profile != null ? 'active' : '' !!}">
                            <div class="icon">
                                <i data-feather="image"></i>
                            </div>
                            <div class="title">
                                <span>@lang('user.form.profile.placeholder')</span>
                            </div>
                        </div>
                        <div
                            class="image-view {!! request('id') && isset($data) && $data->profile != null ? 'active' : '' !!}">
                            <img src="{!! request('id') && isset($data) && $data->profile != null ? asset('file_manager' . $data->profile) : null !!}"
                                onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt="">
                        </div>
                        <input type="text" name="image" s-click-fn="selectImage(event)" autocomplete="off"
                            role="presentation">
                        <input type="hidden" name="tmp_file"
                            value="{!! request('id') && isset($data) && $data->profile != null ? $data->profile : '' !!}">
                    </div>
                </div>
            </div>
            <div class="form-button">
                <button type="submit" color="primary">
                    <i data-feather="save"></i>
                    <span>Submit</span>
                </button>
                <button color="danger" type="button" s-click-link="{!! route('admin-trainer-list', 1) !!}">
                    <i data-feather="x"></i>
                    <span>Cancel</span>
                </button>
            </div>
        </div>
        <div class="form-footer"></div>
    </form>
</div>
@include('admin::file-manager.popup')
@stop
@section('script')
<script>
    $(document).ready(function() {
        $validator("#form", {
            name: {
                required: true,
            },
            experience: {
                required: true,
            },
            skill: {
                required: true,
            },
        });
    });
    function selectImage(e) {
            fileManager({
                multiple: false,
                afterClose: (data, basePath) => {
                    if (data?.length > 0) {
                        const parent = e.target.closest('.form-select-photo');
                        e.target.value = data[0].path;
                        parent
                            .querySelector('.select-photo')
                            .classList.add('active');
                        parent
                            .querySelector('.image-view')
                            .classList
                            .add('active');
                        parent
                            .querySelector('.image-view')
                            .childNodes[0]
                            .nextElementSibling
                            .setAttribute('src', basePath + data[0].path);
                    }
                }
            })
        }
</script>
@stop