<template x-if="student_score">
    <div class="classLogDialogLayout">
        <div class="classLogDialog p-3 h-auto" style="width: 210mm;">
            <div>
                <div class="d-flex justify-content-between">
                    <h3 class="m-0 mb-3">
                        ពិន្ទុប្រឡងរបស់សិស្ស
                    </h3>
                    <span @click="getStudentScore()" class="btn-close cursor-pointer"></span>
                </div>
                <div class="overflow-auto">
                    <div>
                        <span class="font-weight-bolder">ESA - </span>
                        <span class="font-weight-bolder text-danger" x-text="studentScore.id"></span>
                    </div>
                    <div class="d-flex justify-content-between">
                        <div class="d-flex flex-column" style="width: 48%;">
                            <div style="width: 100%;">
                                <div class="mb-2">
                                    <span>
                                        អ្នកចេញវិញ្ញាសារ
                                    </span>
                                </div>
                                <div class="w-100 mb-2"
                                    style="border: 1px solid #4f4f4f; border-radius: 5px;padding: 4px;color: #4f4f4f">
                                    <span style="color: #4f4f4f"
                                        x-text="studentScore.exam_subject.staff.full_name"></span>
                                </div>
                            </div>
                            <div style="width: 100%;">
                                <div class="mb-2">
                                    <span>
                                        ប្រធានបទប្រឡង
                                    </span>
                                </div>
                                <div class="w-100 mb-2"
                                    style="border: 1px solid #4f4f4f; border-radius: 5px;padding: 4px;color: #4f4f4f">
                                    <span style="color: #4f4f4f" x-text="studentScore.exam_subject.description"></span>
                                </div>
                            </div>
                            <div style="width: 100%;">
                                <div class="mb-2">
                                    <span>
                                        ឈ្មោះសិស្ស
                                    </span>
                                </div>
                                <div class="w-100 mb-2"
                                    style="border: 1px solid #4f4f4f; border-radius: 5px;padding: 4px;color: #4f4f4f">
                                    <span style="color: #4f4f4f"
                                        x-text="studentScore.exam_candidate.student.name_khmer"></span>
                                </div>
                            </div>
                            <div style="width: 100%;">
                                <div class="mb-2">
                                    <span>
                                        ទទួលបានពិន្ទុ
                                    </span>
                                </div>
                                <div class="w-100"
                                    style="border: 1px solid #4f4f4f; border-radius: 5px;padding: 4px;color: #4f4f4f">
                                    <span style="color: #4f4f4f" x-text="studentScore.acquired_score"></span>
                                </div>
                            </div>
                        </div>
                        <div style="width: 48%;" class="d-flex justify-content-between">
                            <div>
                                <div class="mb-2">
                                    <span>
                                        រូបភាព
                                    </span>
                                </div>
                                <div style="height: 6.5cm; width: 4.5cm; background: gray;">
                                    <div class="thumbnail photo h-100 w-100" data-fancybox
                                        :data-src="studentScore.exam_candidate.student.profile != null ? `{{asset('file_manager')}}`+studentScore.exam_candidate.student.profile : `{{asset('images/logo/default.png')}}`">
                                        <img :src="studentScore.exam_candidate.student.profile != null ? `{{asset('file_manager')}}`+studentScore.exam_candidate.student.profile : `{{asset('images/logo/default.png')}}`"
                                            onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt=""
                                            style="width: 4.5cm; height: 6.5cm; object-fit:contain;">
                                    </div>
                                </div>
                            </div>
                            <div>
                                <div class="mb-2">
                                    <span>
                                        ក្រដាសចម្លើយ
                                    </span>
                                </div>
                                <div style="height: 6.5cm; width: 4.5cm; background: gray;">
                                    <div class="thumbnail photo h-100 w-100" data-fancybox
                                        :data-src="studentScore.answer_sheet != null ? `{{asset('file_manager')}}`+studentScore.answer_sheet : `{{asset('images/logo/default.png')}}`">
                                        <img :src="studentScore.answer_sheet != null ? `{{asset('file_manager')}}`+studentScore.answer_sheet : `{{asset('images/logo/default.png')}}`"
                                            onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt=""
                                            style="width: 4.5cm; height: 6.5cm; object-fit:contain;">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
</template>