<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LICE SYTEM</title>
    {!! HTML::style('admin-public/css/app.css') !!}
    {!! HTML::style('admin-public/css/view-info.css') !!}
    {!! HTML::script('admin-public/js/app.js') !!}
    <script src="{!! asset('admin-public/js/defer.js') !!}" defer></script>
    <link rel="stylesheet" href="{{ asset('plugin/toastr.min.css') }}">
    <script src="{{ asset('plugin/toastr.min.js') }}"></script>
    <script src="{{ asset('admin-public/js/tinymce/tinymce.min.js') }}" referrerpolicy="origin"></script>
    <script src="https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js"></script>
</head>

<body style="background: lightgray">
    {{-- @yield('index') --}}
    @include('admin::components.toast')
    <nav style="width: 210mm; height: 50px; background: #fff; margin: 0 auto;"
        class="d-flex align-items-center justify-content-between flex-row p-3">
        <div class="d-flex align-items-center">
            <div style="margin-right: 15px">
                <h3>
                    {{strtoupper('lice school trainer portal')}}
                </h3>
            </div>
            <div class="cursor-pointer" s-click-link="{{route('admin-teacher-portal-list')}}">
                <span>
                    Home
                </span>
            </div>
        </div>
        <div class="d-flex  align-items-center">
            <div style="margin-right: 15px">
                <span>
                    {{Auth::user()->username}}
                </span>
            </div>
            <button class="bg-danger" s-click-link="{{route('admin-sign-out')}}" style="height: 30px;">
                <span>
                    Log Out
                </span>
            </button>
        </div>
    </nav>
    <div style="width: 210mm; margin: 0 auto; background: #fff; min-height: 297mm">
        @yield('teacher')
    </div>
    <script lang="ts">
        $(document).ready(function() {
             @if (Session::has('success'))
                 Toast({
                     title: 'Success Message',
                     message: '{!! Session::get('success') !!}',
                     status: 'success',
                     duration: 5000,
                 });
             @elseif(Session::has('error'))
                 Toast({
                     title: 'Error Message',
                     message: '{!! Session::get('error') !!}',
                     status: 'danger',
                     duration: 5000,
                 });
             @elseif(Session::has('warning'))
                 Toast({
                     title: 'Warning Message',
                     message: '{!! Session::get('warning') !!}',
                     status: 'warning',
                     duration: 5000,
                 });
             @endif
        });
    </script>
    @yield('script')
    {!! HTML::script('admin-public/js/body.js') !!}
</body>

</html>