@extends('admin::pages.teacherPortal.index')
@section('teacher')
<div class="p-3" x-data="xExamManagement">
    <div class="w-100 mb-4">
        <button s-click-link="{{route('admin-teacher-portal-list')}}" class="mt-2 w-100 bg-danger text-align-center"
            style="height: 30px; border-radius: 4px;">
            <span class="w-100 text-light">ថយក្រោយ</span>
        </button>
    </div>
    <div>
        <div style="text-align: center">
            <span>
                គ្រប់គ្រងពិន្ទុប្រឡង
            </span>
        </div>
        @if(count($data) > 0)
        <div class="content-body mb-3">
            <div class="font-weight-bolder">
                <span>
                    ព័ត៌មានមុខវិជ្ជាការប្រឡង
                </span>
            </div>
            <div>
                <div class="mb-2">
                    <span>
                        ការប្រឡង
                    </span>
                </div>
                <select class="w-100 mb-2" name="exam" id="" x-model="exam"
                    style="border: 1px solid #4f4f4f; border-radius: 5px;padding: 5px;color: #4f4f4f"
                    @change="getExamSubject()">
                    <option value="">ជ្រើសរើស</option>
                    @foreach($data as $item)
                    <option value="{{$item->id}}">{{$item->exam_type->name}} - {{$item->noted}}</option>
                    @endforeach
                </select>
                <template x-if="subject">
                    <div>
                        <div class="mb-2">
                            <span>
                                មុខវិជ្ជាប្រឡង
                            </span>
                        </div>
                        <select @change="getExamAnswerSheet()" class="w-100 mb-2" name="exam_subject" id=""
                            x-model="exam_subject" x-ref="exam_subjectEL"
                            style="border: 1px solid #4f4f4f; border-radius: 5px;padding: 5px;color: #4f4f4f">
                            <option value="">ជ្រើសរើស</option>
                            <template x-for="(data, index) in examSubjects">
                                <option :value="data.id" x-text="data.description"></option>
                            </template>
                        </select>
                        {{-- <div style="text-align: center">
                            <span>
                                For [<span
                                    x-text="$refs.exam_subjectEL.options[$refs.exam_subjectEL.selectedIndex].text"></span>]
                            </span>
                        </div> --}}
                        @if(in_array(auth()->user()->id, $user_checked))
                        <button @click="dialogCreateOpen()" class="mt-2 w-100 bg-primary text-align-center"
                            style="height: 30px; border-radius: 4px;">
                            <span class="w-100 text-light">បញ្ចូលពិន្ទុថ្មី</span>
                        </button>
                        @endif
                    </div>
                </template>
                <template x-if="answer_sheet">
                    <template x-if="examAnswerSheet.length > 0">
                        <div class="content-body mb-3">
                            <div class="table">
                                <div class="table-wrapper">
                                    <div class="table-header" style="background: #4f4f4f">
                                        <div class="row table-row-10">
                                            <span class="text-light">
                                                EAS ID
                                            </span>
                                        </div>
                                        <div class="row table-row-40">
                                            <span class="text-light">
                                                ឈ្មោះសិស្ស
                                            </span>
                                        </div>
                                        <div class="row table-row-25">
                                            <span class="text-light">
                                                ពិន្ទុសិស្ស (%)
                                            </span>
                                        </div>
                                        <div class="row table-row-25">
                                            <span class="text-light">
                                                សកម្មភាព
                                            </span>
                                        </div>
                                    </div>
                                    <div class="table-body overflow-auto">
                                        <template x-for="data in examAnswerSheet">
                                            <div class="column">
                                                <div class="row table-row-10">
                                                    <span style="color: #4f4f4f" x-text="data.id">
                                                    </span>
                                                </div>
                                                <div class="row table-row-40">
                                                    <span style="color: #4f4f4f"
                                                        x-text="data.exam_candidate.student.name_khmer">
                                                    </span>
                                                </div>
                                                <div class="row table-row-25">
                                                    <span style="color: #4f4f4f" x-text="data.acquired_score">
                                                    </span>
                                                </div>
                                                <div
                                                    class="row table-row-25 d-flex justify-content-center align-items-center">
                                                    <button @click="getStudentScore(data.id)" class="bg-primary w-auto"
                                                        style="border-radius: 4px;">
                                                        <span class="text-light p-2">
                                                            View
                                                        </span>
                                                    </button>
                                                </div>
                                            </div>
                                        </template>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </template>
                </template>
            </div>
        </div>
        @else
        <div style="text-align: center">
            <span class="text-danger font-weight-bolder">
                No Data!
            </span>
        </div>
        @endif
    </div>
    @include('admin::pages.teacherPortal.exam-answer-sheet')
    @include('admin::pages.teacherPortal.student-score')
    <template x-if="loading">
        <div style="position: fixed;
        background-color: rgba(0, 0, 0, 0.6);
        width: 100%;
        top: 0;
        height: 100%;
        left: 0;
        z-index: 999;
        display: flex;
        justify-content: center;
        align-items: center">
            <div style="background-color: #fff;
            width: 40%;
            height: 30%;
            box-shadow: 0 3rem 5rem rgba(0, 0, 0, 0.3);
            border-radius: 5px;">
                <div class="loadingCus loadingCenter m-0 p-0 h-100 align-items-center flex-column" x-show="loading">
                    <div class="loaderSpinnerVer1"></div>
                </div>
            </div>
        </div>
    </template>
</div>
@stop
@section('script')
<script>
    Alpine.data('xExamManagement', () => ({
        // field
        score: null,
        exam: null,
        exam_subject: null,
        student: null,
        // store data
        examSubjects: [],
        examCandidates: [],
        examAnswerSheet: [],
        studentScore: [],
        // modal
        subject: false,
        loading: false,
        dialogOpen: false,
        answer_sheet: false,
        student_score: false,
        async getStudentScore(id){
            if(this.student_score == false){
                this.loading = true;
                await this.fetchStudentScore(id, (res)=> {
                    this.studentScore = res;
                });
                this.loading = false;
                this.student_score = true;   
            }else{
                this.student_score = false;
            }
        },
        async fetchStudentScore(id,callback){
            await Axios({
                url: `{{route('admin-teacher-portal-get-student-score')}}`,
                method: 'GET',
                params: {
                    id: id,
                },
            }).then((response)=>{
                callback(response.data);
            }).catch((err)=> {
                console.log(err);
            });
        },
        async getExamAnswerSheet() {
            this.loading = true;
            this.answer_sheet = true;
            this.examAnswerSheet = [];
            await this.fetchExamAnswerSheet((res)=>{
                this.examAnswerSheet = res;
            });
            this.loading = false;
        },
        async fetchExamAnswerSheet(callback){
            await Axios({
                url: `{{route('admin-teacher-portal-get-exam-answer-sheet')}}`,
                method: 'GET',
                params: {
                    exam_subject_id: this.exam_subject,
                },
            }).then((response)=>{
                callback(response.data);
            }).catch((err)=> {
                console.log(err);
            });
        },
        async createStudentScore(class_id){
            await Axios({
                url: `{{route('admin-teacher-portal-exam-answer-sheet')}}`,
                method: 'POST',
                params: {
                    'class_id': class_id,
                    'score': this.score,
                    'student': this.student,
                    'exam_subject': this.exam_subject, 
                },
            }).then((response)=>{
                this.loading = true;
                if (response.data.status == true) {
                    this.dialogOpen = false;
                    Toast({
                        title: 'Success Message',
                        message: response.data.message,
                        status: 'success',
                        duration: 5000,
                    });
                }else{
                    Toast({
                        title: 'Warning Message',
                        message: response.data.message,
                        status: 'warning',
                        duration: 5000,
                    });
                }
                this.loading = false;
            }).catch((err)=> {
                Toast({
                        title: 'Warning Message',
                        message: 'Invalided valued',
                        status: 'warning',
                        duration: 5000,
                    });
            });
            this.loading = true;
            this.answer_sheet = true;
            await this.fetchExamAnswerSheet((res)=>{
                this.examAnswerSheet = res;
            });
            this.score = null;
            this.loading = false;
        },
        async dialogCreateOpen(){
            if(this.exam_subject == null){
                Toast({
                     title: 'Warning Message',
                     message: 'Invalided valued!',
                     status: 'warning',
                     duration: 5000,
                 });
            }else{
                if(this.dialogOpen == false){
                    this.loading = true;
                    this.examCandidates = null;
                    await this.fetchExamCandidate((res) => {
                        this.examCandidates = res;
                    });
                    this.loading = false;
                    this.dialogOpen = true;
                }
                else{
                    this.dialogOpen = false
                }
            }
        },
        async fetchExamCandidate(callback){
            await Axios({
                url: `{{route('admin-teacher-portal-get-exam-candidate')}}`,
                method: 'GET',
                params: {
                    exam_id: this.exam,
                },
            }).then((response)=>{
                callback(response.data);
            }).catch((err)=> {
                console.log(err);
            });
        },
        async getExamSubject() {
            this.loading = true;
            this.subject = true;
            this.examSubjects = [];
            this.examAnswerSheet = [];
            await this.fetchExamSubject((res)=>{
                this.examSubjects = res;
            });
            this.loading = false;
        },
        async fetchExamSubject(callback) {
            await Axios({
                url: `{{route('admin-teacher-portal-get-exam-subject')}}`,
                method: 'GET',
                params: {
                    exam_id: this.exam,
                },
            }).then((response)=>{
                callback(response.data);
            }).catch((err)=> {
                console.log(err);
            });
        },
    }));
</script>
@stop