@extends('admin::pages.teacherPortal.index')
@section('teacher')
<div class="p-3">
    <div class="w-100 mb-4">
        <button s-click-link="{{route('admin-teacher-portal-list')}}" class="mt-2 w-100 bg-danger text-align-center"
            style="height: 30px; border-radius: 4px;">
            <span class="w-100 text-light">ថយក្រោយ</span>
        </button>
    </div>
    <div>
        <div style="text-align: center">
            <span>
                បញ្ជីឈ្មោះសិស្ស
            </span>
        </div>
        <div>
            <span>
                លេខកូដថ្នាក់: <span class="font-weight-bolder">{{request('class_id')}}</span>
            </span>
        </div>
        <div>
            <span>
                មុខវិជ្ជាសរុប: <span class="font-weight-bolder">{{count($data)}}</span>
            </span>
        </div>
        @if(count($data) > 0)
        <div class="content-body mb-3">
            <div class="table">
                <div class="table-wrapper">
                    <div class="table-header" style="background: #4f4f4f">
                        <div class="row table-row-10">
                            <span class="text-light">
                                លេខរៀង
                            </span>
                        </div>
                        <div class="row table-row-40">
                            <span class="text-light">
                                ឈ្មោះមុខវិជ្ជា
                            </span>
                        </div>
                        <div class="row table-row-25">
                            <span class="text-light">
                                ដំណើរការថ្នាក់
                            </span>
                        </div>
                        <div class="row table-row-25">
                            <span class="text-light">
                                ដំណើរការថ្នាក់(%)
                            </span>
                        </div>
                    </div>
                    <div class="table-body overflow-auto">
                        @foreach($data as $index => $item)
                        <div class="column">
                            <div class="row table-row-10">
                                <span style="color: 4f4f4f;">
                                    {{$index + 1}}
                                </span>
                            </div>
                            <div class="row table-row-40">
                                <span style="color: 4f4f4f;">
                                    {{$item->short_name ?? ''}} - {{$item->name ?? ''}}
                                </span>
                            </div>
                            <div class="row table-row-25">
                                <span style="color: 4f4f4f;">
                                    {{count($item->attendance)}}/{{round($item->practice_hour/3)}}
                                </span>
                            </div>
                            <div class="row table-row-25">
                                <span style="color: 4f4f4f;">
                                    {{number_format((float)(count($item->attendance)/round($item->practice_hour/3))*100,
                                    2, '.', '')}}
                                </span>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
        @endif
    </div>
</div>
@stop