<div class="content-body d-flex flex-column overflow-auto mt-3">
    <div id="student-internship-place" class="bg-white mb-3">
        <div id="student-list" class="form-body p-3 mt-3">
            <h2 class="mt-0">
                {!! strtoupper('Student to intern place list') !!}
            </h2>
            <div class="row">
                <div>
                    <span>
                        Total Unassign: <span class="text-primary">{{$count_unassign}} people(s)</span>
                    </span>
                </div>
                <div>
                    <span>
                        Total Assigned: <span class="text-primary">{{$count_assigned}} people(s)</span>
                    </span>
                </div>
            </div>
            <div class="row">
                <div class="table">
                    <div class="table-wrapper">
                        <div class="table-header bg-black text-light">
                            <div class="row table-row-10">
                                <span class="font-sm">{!! strtoupper('N°') !!}</span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm">{!! strtoupper('ID') !!}</span>
                            </div>
                            <div class="row table-row-20">
                                <span class="font-sm">{!! strtoupper('Name') !!}</span>
                            </div>
                            <div class="row table-row-25">
                                <span class="font-sm">{!! strtoupper('Intern at') !!}</span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm">{!! strtoupper('start on') !!}</span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm">{!! strtoupper('action') !!}</span>
                            </div>
                        </div>
                        <div class="table-body overflow-auto">
                            @foreach($data->sortBy('id') as $index => $item)
                            <div class="column">
                                <div class="row table-row-10">
                                    <span>{!! $index + 1 !!}</span>
                                </div>
                                <div class="row table-row-15">
                                    <span>{!! $item->id ?? '--' !!}</span>
                                </div>
                                <div class="row table-row-20">
                                    <span>{!! $item->name_khmer ?? '--' !!}</span>
                                </div>
                                <div class="row table-row-25">
                                    <span>
                                        @if($item->student_intern_places &&
                                        count($item->student_intern_places->where('class_id', request('class_id'))))
                                        @foreach($item->student_intern_places as $place)
                                        @if($place->class_id == request('class_id'))
                                        {!! $place->internship_place->place_name ?? '--' !!}
                                        @endif
                                        @endforeach
                                        @else
                                        --
                                        @endif
                                    </span>
                                </div>
                                <div class="row table-row-15">
                                    <span>
                                        @if($item->student_intern_places &&
                                        count($item->student_intern_places->where('class_id', request('class_id'))))
                                        @foreach($item->student_intern_places as $place)
                                        @if($place->class_id == request('class_id'))
                                        {!! $place->start_date ?? '--' !!}
                                        @endif
                                        @endforeach
                                        @else
                                        --
                                        @endif
                                    </span>
                                </div>
                                <div class="row table-row-15 h-100 d-flex justify-content-center align-items-center">
                                    <span class="font-sm h-50">
                                        @if($item->student_intern_places &&
                                        count($item->student_intern_places->where('class_id', request('class_id'))))
                                        @foreach($item->student_intern_places as $place)
                                        @can('student-intern-place-destroy')
                                        <button class="btn-create bg-danger h-100" onclick="$onConfirmMessage(
                                            '{!! route('admin-assign-internship-place-unassign', ['class_id' => request('class_id'), 'student_id' => $item->id, 'start_date' => $place->start_date]) !!}',
                                            '@lang('Do you want to uassign student!')',
                                            {
                                                confirm: '@lang('dialog.button.ok')',
                                                cancel: '@lang('dialog.button.cancel')'
                                            }
                                        );">
                                            <span>{!! strtoupper('Unassign') !!}</span>
                                        </button>
                                        @endcan
                                        @endforeach
                                        @else
                                        @can('student-intern-place-create')
                                        <button class="btn-create bg-primary h-100"
                                            @click="dialogClassLog({{$item->id}})">
                                            <span>{!! strtoupper('Assign') !!}</span>
                                        </button>
                                        @endcan
                                        @endif
                                    </span>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('admin::pages.studentInternPlace.assign-student-internship-place')
    @can('internship-place-view')
    <div id="internship-place" class="bg-white">
        <div class="form-body p-3 mt-3">
            <h2 class="mt-0">
                {!! strtoupper('Internship place list') !!}
            </h2>
            <div class="row d-flex justify-content-between align-items-center">
                <div>
                    <span>
                        Result Count: <span class="text-primary">{{count($intern_place)}}</span>
                    </span>
                </div>
                <div class="row table-row-15 h-100 d-flex justify-content-center align-items-center">
                    @can('internship-place-create')
                    <span class="h-50">
                        <button class="btn-create bg-primary h-100"
                            s-click-link="{!! route('admin-internship-place-create') !!}">
                            <span>{!! strtoupper('create new intern place') !!}</span>
                        </button>
                    </span>
                    @endcan
                </div>
            </div>
            <div class="row">
                <div class="table">
                    <div class="table-wrapper">
                        <div class="table-header bg-black text-light">
                            <div class="row table-row-15">
                                <span class="font-sm">{!! strtoupper('ID') !!}</span>
                            </div>
                            <div class="row table-row-25">
                                <span class="font-sm">{!! strtoupper('internship place name') !!}</span>
                            </div>
                            <div class="row table-row-30">
                                <span class="font-sm">{!! strtoupper('location') !!}</span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm">{!! strtoupper('contact number') !!}</span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm">{!! strtoupper('action') !!}</span>
                            </div>
                        </div>
                        <div class="table-body overflow-auto">
                            @foreach($intern_place as $index => $item)
                            <div class="column">
                                <div class="row table-row-15">
                                    <span>{!! $item->id ? $item->id : '--' !!}</span>
                                </div>
                                <div class="row table-row-25">
                                    <span>{!! $item->place_name ?? '--' !!}</span>
                                </div>
                                <div class="row table-row-30">
                                    <span>
                                        {{ $item->location ?? '--'}}
                                    </span>
                                </div>
                                <div class="row table-row-15">
                                    <span>
                                        {{$item->contact_number ?? '--'}}
                                    </span>
                                </div>
                                <div class="row table-row-15 h-100 d-flex justify-content-center align-items-center">
                                    @if ($item->status != 'trash')
                                    @can('internship-place-update')
                                    <span class="font-sm h-50">
                                        <button class="btn-create bg-primary h-100"
                                            s-click-link="{!! route('admin-internship-place-create', $item->id) !!}">
                                            <span>{!! strtoupper('Edit') !!}</span>
                                        </button>
                                    </span>
                                    @endcan
                                    @endif
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endcan
</div>