<template x-if="dialogOpen">
    <div class="classLogDialogLayout">
        <div class="classLogDialog p-3 h-auto">
            <div class="form-admin p-3">
                <div id="form" class="form-wrapper p-0">
                    <div class="form-body p-0" style="box-shadow: none">
                        <div class="row">
                            <h2 class="mt-0">
                                Assign Student Internship Place
                            </h2>
                        </div>
                        <div class="row">
                            <div class="form-row">
                                <label>Class <span>*</span></label>
                                <select x-model="class_id" name="class_id">
                                    <option :value="{{request('class_id')}}" x-text="{{request('class_id')}}">
                                    </option>
                                </select>
                                @error('class_id')
                                <span class="error">{!! $message !!}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="row-2">
                            <div class="form-row">
                                <label>Student<span>*</span></label>
                                <select x-model="student_id" name="student_id">
                                    <option :value="student.id" x-text="student.name_khmer + ' ' + student.name_latin">
                                    </option>
                                </select>
                                @error('student_id')
                                <span class="error">{!! $message !!}</span>
                                @enderror
                            </div>
                            <div class="form-row">
                                <label>Select Internship Place <span>*</span></label>
                                <select x-model="internship_place_id" name="internship_place_id">
                                    <option>Please select internship place</option>
                                    @foreach ($intern_place as $ip)
                                    <option :value="{{$ip->id}}">
                                        {{$ip->place_name}}
                                    </option>
                                    @endforeach
                                </select>
                                @error('internship_place_id')
                                <span class="error">{!! $message !!}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="row-2">
                            <div class="form-row">
                                <label>Choose Start Date<span>*</span></label>
                                <input type="date" x-model="start_date" name="start_date">
                                @error('start_date')
                                <span class="error">{!! $message !!}</span>
                                @enderror
                            </div>
                            <div class="form-row">
                                <label>Intern Status <span>*</span></label>
                                <select x-model="is_intern_pass" name="is_intern_pass">
                                    <option>Please select intern status(default fail)</option>
                                    <option :value="'0'">
                                        {{strtoupper('Fail')}}
                                    </option>
                                    <option :value="'1'">
                                        {{strtoupper('Pass')}}
                                    </option>
                                </select>
                                @error('is_intern_pass')
                                <span class="error">{!! $message !!}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-button">
                            <button type="submit" color="primary"
                                @click="studentInternPlaceLog(student.id, {{request('class_id')}})">
                                <i data-feather="save"></i>
                                <span>Submit</span>
                            </button>
                            <button color="danger" type="button" @click="dialogOpen=false">
                                <i data-feather="x"></i>
                                <span>Cancel</span>
                            </button>
                        </div>
                    </div>
                    <div class="form-footer"></div>
                </div>
            </div>
        </div>
    </div>
</template>