@extends('admin::shared.layout')
@section('layout')
    <div class="content-wrapper">
        <div class="header">
            @include('admin::shared.header', ['header_name' => 'Display Student Info'])
            <div class="header-tab">
                <div class="header-tab-wrapper">
                    <div class="menu-row">
                        <div class="menu-item text-primary" s-click-link="{!! route('admin-student-list', 1) !!}">
                            Back</div>
                    </div>
                </div>
            </div>
        </div>
        <div class="form-admin p-5 mt-2 mb-2">
            <div class="form-wrapper p-0">
                <div id="class-info" class="form-body p-3">
                    <h3 class="mt-0">
                        {!! strtoupper('Student Infomation') !!}
                    </h3>
                    <div class="row-3">
                        <div class="form-row">
                            <div class="thumbnail w-auto" data-fancybox style="height: 255px"
                                data-src="{{ asset('file_manager' . $data->profile) }}">
                                <img src="{!! $data->profile != null ? asset('file_manager' . $data->profile) : asset('images/logo/default.png') !!}"
                                    onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt=""
                                    width="100%" height="100%">
                            </div>
                        </div>
                        <div>
                            <div class="form-row">
                                <span>
                                    Name Khmer
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 6px 10px;">
                                    {{ $data->name_khmer ?? '--' }}
                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    ID Card
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    {{ $data->id_card ?? '--' }}
                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Gender
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    {{ $data->gender ?? '--' }}
                                </span>
                            </div>
                        </div>
                        <div>
                            <div class="form-row">
                                <span>
                                    Name Latin
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 8px 10px;">
                                    {{ $data->name_latin ?? '--' }}
                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Student ID
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    {{ $data->sid ?? '--' }}
                                </span>
                            </div>
                            <div class="form-row">
                                <span>
                                    Date of Birth
                                </span>
                                <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                    {{ $data->dob ?? '--' }}
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="row-3">
                        <div class="form-row">
                            <span>
                                Education
                            </span>
                            <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                {{ $data->education_level->name ?? '--' }}
                            </span>
                        </div>
                        <div class="form-row">
                            <span>
                                Phone Number
                            </span>
                            <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                {{ $data->phone ?? '--' }}
                            </span>
                        </div>
                        <div class="form-row">
                            <span>
                                Telegram Number
                            </span>
                            <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                {{ $data->phone_with_telegram ?? '--' }}
                            </span>
                        </div>
                    </div>
                    <div class="row-3">
                        <div class="form-row">
                            <span>
                                Email
                            </span>
                            <span class="border-1-gray w-100 mt-2 text-black-50" style="padding: 10px;">
                                {{ $data->email ?? '--' }}
                            </span>
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-row">
                            <span>
                                Current Working Plce
                            </span>
                            <span class="border-1-gray w-100 mt-2 text-black-50"
                                style="padding: 10px; text-align: justify;">
                                {!! $data->current_working_place ?? '--' !!}
                            </span>
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-row">
                            <span>
                                Work Experience
                            </span>
                            <span class="border-1-gray w-100 mt-2 text-black-50"
                                style="padding: 10px; text-align: justify;">
                                {!! $data->working_experience ?? '--' !!}
                            </span>
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-row">
                            <span>
                                Noted
                            </span>
                            <span class="border-1-gray w-100 mt-2 text-black-50"
                                style="padding: 10px; text-align: justify;">
                                {!! $data->noted ?? '--' !!}
                            </span>
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-row">
                            <span>
                                Address Khmer
                            </span>
                            <span class="border-1-gray w-100 mt-2 text-black-50"
                                style="padding: 10px; text-align: justify;">
                                {!! $data->address_khmer ?? '--' !!}
                            </span>
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-row">
                            <span>
                                Address Latin
                            </span>
                            <span class="border-1-gray w-100 mt-2 text-black-50"
                                style="padding: 10px; text-align: justify;">
                                {!! $data->address_latin ?? '--' !!}
                            </span>
                        </div>
                    </div>
                    @if (count($data->classes) > 0)
                        <h3>
                            {{ strtoupper('Class Enrollment') }}
                        </h3>
                        <div class="row">
                            <div class="table">
                                <div class="table-wrapper p-0">
                                    <div class="table-header bg-black text-light">
                                        <div class="row table-row-5">
                                            <span class="font-sm">{!! strtoupper('N°') !!}</span>
                                        </div>
                                        <div class="row table-row-10">
                                            <span class="font-sm">{!! strtoupper('class id') !!}</span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span class="font-sm">{!! strtoupper('occupation') !!}</span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span class="font-sm">{!! strtoupper('type') !!}</span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span class="font-sm">{!! strtoupper('level') !!}</span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span class="font-sm">{!! strtoupper('tranier') !!}</span>
                                        </div>
                                        <div class="row table-row-15">
                                            <span class="font-sm">{!! strtoupper('processing') !!}</span>
                                        </div>
                                        <div class="row table-row-10">
                                            <span class="font-sm">{!! strtoupper('start date') !!}</span>
                                        </div>
                                        <div class="row table-row-10">
                                            <span class="font-sm">{!! strtoupper('end date') !!}</span>
                                        </div>
                                    </div>
                                    <div class="table-body overflow-auto">
                                        @foreach ($data->classes as $index => $class)
                                            <div class="column">
                                                <div class="row table-row-5">
                                                    <span class="font-sm">{!! $index + 1 !!}</span>
                                                </div>
                                                <div class="row table-row-10">
                                                    <span class="font-sm">{!! $class->id ?? '--' !!}</span>
                                                </div>
                                                <div class="row table-row-15">
                                                    <span class="font-sm">{!! $class->class_structure_program->structure_program->class_occupation->name ?? '--' !!}</span>
                                                </div>
                                                <div class="row table-row-15">
                                                    <span class="font-sm">{!! $class->class_type->name ?? '--' !!}</span>
                                                </div>
                                                <div class="row table-row-15">
                                                    <span class="font-sm">{!! $class->class_level->name ?? '--' !!}</span>
                                                </div>
                                                <div class="row table-row-15">
                                                    <span class="font-sm">{!! $class->staff->full_name ?? '--' !!}</span>
                                                </div>
                                                <div class="row table-row-15">
                                                    <span class="font-sm">{!! $class->class_status->name ?? '--' !!}</span>
                                                </div>
                                                <div class="row table-row-10">
                                                    <span class="font-sm">{!! $class->start_date ?? '--' !!}</span>
                                                </div>
                                                <div class="row table-row-10">
                                                    <span class="font-sm">{!! $class->end_date ?? '--' !!}</span>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                        <h3>
                            {{ strtoupper('Certificate') }}
                        </h3>
                    @endif
                </div>
            </div>
        </div>
    </div>

@stop
