@extends('admin::shared.layout')
@section('layout')
    <div class="content-wrapper" x-data="student">
        <div class="header">
            @include('admin::shared.header', ['header_name' => 'Student Management'])
            <div class="header-tab">
                <div class="header-tab-wrapper">
                    <div class="menu-row">
                        <div class="menu-item {!! Request::is('admin/student/list/1') ? 'active' : '' !!}" s-click-link="{!! route('admin-student-list', 1) !!}">
                            Active
                        </div>
                        <div class="menu-item {!! Request::is('admin/student/list/2') ? 'active' : '' !!}" s-click-link="{!! route('admin-student-list', 2) !!}">
                            @lang('user.tab.disable')
                        </div>
                        <div class="menu-item {!! Request::is('admin/student/list/request_approval') ? 'active' : '' !!}" s-click-link="{!! route('admin-student-list', 'request_approval') !!}">
                            Request Approval
                        </div>
                    </div>
                </div>
                <div class="header-action-button">
                    <form class="filter" action="{!! url()->current() !!}" method="GET">
                        <div class="form-row">
                            <select name="education_level" class="bg-transparent" style="width: 100%;">
                                <option value="">Select Education Level</option>
                                @foreach ($education_levels as $item)
                                    <option value="{{ $item->id }}"
                                        {{ request('education_level') == $item->id ? 'selected' : '' }}>{{ $item->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-row">
                            <input type="text" name="keyword" placeholder="@lang('user.filter.search')"
                                value="{!! request('keyword') !!}">
                            <i data-feather="filter"></i>
                        </div>
                        <button mat-flat-button type="submit" class="btn-create bg-success">
                            <i data-feather="search"></i>
                            <span>Search</span>
                        </button>
                    </form>
                    @can('student-create')
                        <button class="btn-create" s-click-link="{!! route('admin-student-create') !!}">
                            <i data-feather="plus-circle"></i>
                            <span>Create New Student</span>
                        </button>
                    @endcan
                    <button s-click-link="{!! route('admin-student-export-excel', ['id' => request('id'), 'education_level' => request('education_level'), 'keyword' => request('keyword')]) !!}">
                        <i data-feather="download"></i>
                        <span>Excel</span>
                    </button>
                    <button s-click-link="{!! url()->current() !!}">
                        <i data-feather="refresh-ccw"></i>
                        <span>Reload</span>
                    </button>
                </div>
            </div>
        </div>
        <div class="content-body">
            @include('admin::pages.student.table')
            @include('admin::pages.student.study-background')
        </div>
    </div>
@stop

@section('script')
    <script>
        Alpine.data('student', () => ({

            init() {

            },
            openStudyBackgroundDialog(data) {
                this.$store.studyBackgroundDialog.open({
                    data: data,
                    afterClosed: (res) => {
                        if (res) {
                            this.table.reload();
                        }
                    }
                });
            },
        }));
    </script>
@stop
