<div class="table">
    @if ($data->count() > 0)
        <div class="table-wrapper">
            <div class="table-header">
                <div class="row table-row-10">
                    <span>Pro. Detail ID</span>
                </div>
                <div class="row table-row-10">
                    <span>Lesson ID</span>
                </div>
                <div class="row table-row-25">
                    <span>Lesson Name</span>
                </div>
                <div class="row table-row-25">
                    <span>Lesson Occupation</span>
                </div>
                <div class="row table-row-15">
                    <span>Lesson Practice hrs</span>
                </div>
                <div class="row table-row-15">
                    <span>Lesson Theory hrs</span>
                </div>
            </div>
            <div class="table-body">
                @foreach ($data as $index => $value)
                    <div class="column bg-primary text-light">
                        <div class="row table-row-30">
                            <span>
                                Structure Program ID: {!! $value->id ? $value->id : '--' !!}
                            </span>
                        </div>
                        <div class="row table-row-30">
                            <span>
                                @if ($value->class_occupation_id)
                                    @foreach ($class_occupations as $class_occupation)
                                        @if ($value->class_occupation_id == $class_occupation->id)
                                            Program Occupation: {!! $class_occupation->name !!}
                                        @endif
                                    @endforeach
                                @else
                                    {!! '--' !!}
                                @endif
                            </span>
                        </div>
                        <div class="row table-row-30 text left">
                            <span>
                                Program Name: {!! $value->description ? $value->description : '--' !!}
                            </span>
                        </div>
                        <div class="row table-row-10">
                            @canany(['structure-program-assign', 'structure-program-destroy',
                                'structure-program-update', 'structure-program-unassign'])
                                <div class="dropdown">
                                    <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                                        data-mdb-toggle="dropdown" aria-expanded="false">
                                    </i>
                                    <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                        @if ($value->status != 'trash')
                                            {{-- @if ($value->is_check) --}}
                                            @if ($value->class_structure_program)
                                                @can('structure-program-unassign')
                                                    <a class="dropdown-item enable-btn"
                                                        @click="onConfirmMessage({{ $value->id }}, {{ $value->class_structure_program->class_id }})">
                                                        <i data-feather="rotate-ccw"></i>
                                                        <span>Remove From Class</span>
                                                    </a>
                                                @endcan
                                            @else
                                                @can('structure-program-update')
                                                    <li>
                                                        <a class="dropdown-item" s-click-link="{!! route('admin-structure-program-create', $value->id) !!}">
                                                            <i data-feather="edit"></i>
                                                            <span>Edit</span>
                                                        </a>
                                                    </li>
                                                @endcan
                                                @can('structure-program-assign')
                                                    <li>
                                                        <a class="dropdown-item" s-click-link="{!! route('admin-structure-program-assign-class', $value->id) !!}">
                                                            <i data-feather="edit"></i>
                                                            <span>Assign to Class</span>
                                                        </a>
                                                    </li>
                                                @endcan
                                                @can('structure-program-destroy')
                                                    <li>
                                                        <a class="dropdown-item enable-btn"
                                                            onclick="$onConfirmMessage(
                                                                '{!! route('admin-structure-program-delete', $value->id) !!}',
                                                                'Are you sure to remove structured program with id {!! $value->id !!}',
                                                                {
                                                                    confirm: 'Remove',
                                                                    cancel: '@lang('dialog.button.cancel')'
                                                                },
                                                            );">
                                                            <i data-feather="rotate-ccw"></i>
                                                            <span>Remove</span>
                                                        </a>
                                                    </li>
                                                @endcan
                                            @endif
                                        @endif
                                    </ul>
                                </div>
                            @endcan
                        </div>
                    </div>
                    @foreach ($value->lesson_id as $item)
                        @foreach ($lessons as $lesson)
                            @if ($item == $lesson->id)
                                <div class="column">
                                    <div class="row table-row-10">
                                        <span>
                                            {!! $value->id !!}
                                        </span>
                                    </div>
                                    <div class="row table-row-10">
                                        <span>
                                            {!! $lesson->id !!}
                                        </span>
                                    </div>
                                    <div class="row table-row-25">
                                        <span>
                                            {!! $lesson->name !!}
                                        </span>
                                    </div>
                                    <div class="row table-row-25">
                                        <span>
                                            @foreach ($lesson_occupations as $lesson_occupation)
                                                @if ($lesson->lesson_occupation_id == $lesson_occupation->id)
                                                    {!! $lesson_occupation->name !!}
                                                @endif
                                            @endforeach
                                        </span>
                                    </div>
                                    <div class="row table-row-15">
                                        <span>
                                            {!! $lesson->practice_hour ? $lesson->practice_hour . ' ' . ($lesson->practice_duration_type ? $lesson->practice_duration_type : '') : '' !!}
                                        </span>
                                    </div>
                                    <div class="row table-row-15">
                                        <span>
                                            {!! $lesson->theory_hour ? $lesson->theory_hour . ' ' . ($lesson->theory_duration_type ? $lesson->theory_duration_type : '') : '' !!}
                                        </span>
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    @endforeach
                @endforeach
            </div>
            <div class="table-footer">
                @include('admin::components.pagination', ['paginate' => $data])
            </div>
        </div>
    @else
        @component('admin::components.empty', [
            'name' => 'Structure Program is empty',
            'msg' => 'You can create a new Structure Program by clicking the button below.',
            'permission' => 'structure-program-create',
            'url' => route('admin-structure-program-create'),
            'button' => 'Create Structure Program',
        ])
        @endcomponent
    @endif
</div>
