@extends('admin::shared.layout')
@section('layout')
    <div class="form-admin" x-data="structureProgram">
        <div class="form-bg"></div>
        <form id="form" class="form-wrapper" action="{!! route('admin-structure-program-save', request('id')) !!}" method="POST" enctype="multipart/form-data">
            <div class="form-header">
                <h3>
                    <i data-feather="arrow-left" s-click-link="{!! route('admin-structure-program-list', 1) !!}"></i>
                    {!! request('id') ? 'Update Program Structure' : 'Create Program Structure' !!}
                </h3>
            </div>
            {{ csrf_field() }}
            <div class="form-body">
                <div class="row">
                    <div class="form-row">
                        <label>Select Class Occupation <span>*</span></label>
                        <select name="class_occupation_id">
                            <option value="">Please select one of class occupation</option>
                            @foreach ($class_occupations as $class_occupation)
                                <option value="{!! $class_occupation->id !!}" {!! (request('id')
                                        ? ($class_occupation->id == $data->class_occupation_id
                                            ? 'selected'
                                            : '')
                                        : old('class_occupation_id') == $class_occupation->id)
                                    ? 'selected'
                                    : '' !!}>
                                    {!! $class_occupation->name !!}
                                </option>
                            @endforeach
                        </select>
                        @error('class_occupation_id')
                            <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="row">
                    <div class="form-row">
                        <label>Description</label>
                        <textarea name="description" placeholder="Description">{!! request('id') ? $data->description : old('description') !!}</textarea>
                        @error('description')
                            <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="row">
                    <div class="form-row m-0">
                        <label>Select Lesson<span>*</span></label>
                        <input class="cursor-pointer" type="text" x-model="lesson_name"
                            placeholder="Please select lesson" readonly @click="selectLesson()">
                        <input type="hidden" name="lesson_id" id="lesson_id">
                    </div>
                </div>
                <div class="form-button">
                    <button type="submit" color="primary">
                        <i data-feather="save"></i>
                        <span>Submit</span>
                    </button>
                    <button color="danger" type="button" s-click-link="{!! route('admin-structure-program-list', 1) !!}">
                        <i data-feather="x"></i>
                        <span>Cancel</span>
                    </button>
                </div>
            </div>
            <div class="form-footer"></div>
        </form>
    </div>
@stop
@section('script')
    <script>
        Alpine.data('structureProgram', () => ({
            lesson_name: null,
            lesson_ids: [],
            old_lesson_ids: @json(request('id') ? $data->lessons : []),
            init() {
                if (@json(request('id'))) {
                    this.old_lesson_ids.forEach(element => {
                        this.lesson_ids.push({
                            _id: element.id,
                            _title: element.name,
                            _description: element?.occupation?.name,
                        });
                    });
                    this.lesson_name = this.old_lesson_ids.map(element => element.name);
                    $('#lesson_id').val(this.lesson_ids.map(item => item._id));
                }
            },
            selectLesson() {
                SelectOption({
                    title: "Select Lesson",
                    placeholder: "Search Lesson",
                    multiple: true,
                    unselect: false,
                    selected: this.lesson_ids,
                    onReady: (callback_data) => { 
                        Axios({
                                url: "{{ route('admin-structure-program-lesson') }}",
                                method: 'GET'
                            })
                            .then(response => {
                                const data = response?.data?.data?.map(item => {
                                    return {
                                        _id: item.id,
                                        _title: item.name,
                                        _description: item?.occupation?.name,
                                        _time: 'PR: ' + item?.practice_hour + item
                                            .practice_duration_type + ', TH: ' + item
                                            ?.theory_hour + item.theory_duration_type,
                                    }
                                });
                                callback_data(data);
                            });
                    },
                    onSearch: (value, callback_data) => {
                        queueSearch = setTimeout(() => {
                            Axios({
                                    url: "{{ route('admin-structure-program-lesson') }}",
                                    params: {
                                        search: value,
                                    },
                                    method: 'GET'
                                })
                                .then(response => {
                                    const data = response?.data?.data?.map(
                                        item => {
                                            return {
                                                _id: item.id,
                                                _title: item.name,
                                                _description: item?.occupation
                                                    ?.name,
                                                _time: 'PR: ' + item
                                                    ?.practice_hour + item
                                                    .practice_duration_type +
                                                    ', TH: ' + item?.theory_hour +
                                                    item.theory_duration_type

                                            }
                                        });
                                    callback_data(data);
                                });
                        }, 1000);
                    },
                    afterClose: (res) => {
                        if (res?.length > 0) {
                            let data = res.map(item => {
                                return {
                                    _id: item._id,
                                    _title: item._title,
                                    _description: item._description
                                }
                            });
                            this.lesson_ids = data.map(item => item);
                            this.lesson_name = data.map(item => item._title);
                            $('#lesson_id').val(data.map(item => item._id));
                        }
                    }
                });
            },
        }));
        $(document).ready(function() {
            $validator("#form", {
                class_occupation_id: {
                    required: true,
                },
                lesson_id: {
                    required: true,
                },
            });
        });
    </script>
@stop
