@extends('admin::shared.layout')
@section('layout')
<div class="form-admin">
    <div class="form-bg"></div>
    <form id="form" class="form-wrapper" action="{!! route('admin-question-save', request('id'))!!}" method="POST"
        enctype="multipart/form-data">
        <div class="form-header">
            <h3>
                Question
            </h3>
        </div>
        {{ csrf_field() }}
        <div class="form-body">
            <div class="row">
                <div class="form-row">
                    <label>Status<span>*</span></label>
                    <select name="status" id="">
                        <option value="1" {{request('id') && $data->status == 1 ? 'selected' : old('status')}}>Active
                        </option>
                        <option value="1" {{request('id') && $data->status == 2 ? 'selected' : old('status')}}>Disable
                        </option>
                    </select>
                    @error('title')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
            </div>
            <div class="row-2">
                <div class="form-row">
                    <label>Question<span>*</span></label>
                    <textarea style="min-height: 300px;"
                        name="question">{!! request('id') ? $data->question : old('question') !!}</textarea>
                    @error('question')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
                <div class="form-row">
                    <label>Answer<span>*</span></label>
                    <textarea style="min-height: 300px;"
                        name="answer">{!! request('id') ? $data->answer : old('answer') !!}</textarea>
                    @error('answer')
                    <label class="error">{{ $message }}</label>
                    @enderror
                </div>
            </div>
            <div class="form-button">
                <button type="submit" color="primary">
                    <i data-feather="save"></i>
                    <span>Submit</span>
                </button>
                <button color="danger" type="button" s-click-link="{!! route('admin-question-list', 1) !!}">
                    <i data-feather="x"></i>
                    <span>Cancel</span>
                </button>
            </div>
        </div>
        <div class="form-footer"></div>
    </form>
</div>
@include('admin::file-manager.popup')
@stop
@section('script')
<script>
    $(document).ready(function() {
        $validator("#form", {
            question: {
                required: true,
            },
            answer: {
                required: true,
            },
        });
    });
    function selectImage(e) {
            fileManager({
                multiple: false,
                afterClose: (data, basePath) => {
                    if (data?.length > 0) {
                        const parent = e.target.closest('.form-select-photo');
                        e.target.value = data[0].path;
                        parent
                            .querySelector('.select-photo')
                            .classList.add('active');
                        parent
                            .querySelector('.image-view')
                            .classList
                            .add('active');
                        parent
                            .querySelector('.image-view')
                            .childNodes[0]
                            .nextElementSibling
                            .setAttribute('src', basePath + data[0].path);
                    }
                }
            })
        }
</script>
@stop