<div class="table">
    @if ($data->count() > 0)
        <div class="table-wrapper">
            <div class="table-header">
                <div class="row table-row-15">
                    <span>Class Processing Status</span>
                </div>
                <div class="row table-row-15">
                    <span>Struct. Occupation</span>
                </div>
                <div class="row table-row-20">
                    <span>Struct. Name</span>
                </div>
                <div class="row table-row-10">
                    <span>Lesson Count</span>
                </div>
                <div class="row table-row-15">
                    <span>Total Practice HRS</span>
                </div>
                <div class="row table-row-15">
                    <span>Total Theory HRS</span>
                </div>
                <div class="row table-row-10">
                    <span>Total Day Count</span>
                </div>
            </div>
            <div class="table-body">
                @foreach ($data as $index => $item)
                    <div class="column">
                        {{-- <div class="row table-row-5 text">
                            <span>
                                {!! $item->structure_program_id ? $item->structure_program_id : '--' !!}
                            </span>
                        </div>
                        <div class="row table-row-10 text">
                            <span>
                                {!! $item->class_id ? $item->class_id : '--' !!}
                            </span>
                        </div> --}}
                        <div class="row table-row-15 text">
                            <span>{{ $item?->classes->class_status?->name ?? '--' }}</span>
                        </div>
                        <div class="row table-row-15">
                            <span>{{ $item?->structure_program?->class_occupation?->name ?? '--' }}</span>
                        </div>
                        <div class="row table-row-20">
                            <span>{{ $item->structure_program?->description ?? '--' }}</span>
                        </div>
                        <div class="row table-row-10">
                            <span>
                                @if ($item->structure_program_id)
                                    @foreach (\DB::table('structure_programs')->where('id', $item->structure_program_id)->get() as $sp)
                                        {!! \DB::table('structure_programs')->where('class_occupation_id', $sp->class_occupation_id)->count() !!}
                                    @endforeach
                                @else
                                    {!! '--' !!}
                                @endif
                            </span>
                        </div>
                        <div class="row table-row-15">
                            <span>
                                {{ calcTime(DB::table('lessons')->whereIn('id', $item?->structure_program?->lesson_id)->get(), 'practice') }}
                            </span>
                        </div>
                        <div class="row table-row-15">
                            <span>
                                {{ calcTime(DB::table('lessons')->whereIn('id', $item?->structure_program?->lesson_id)->get(), 'theory') }}
                            </span>
                        </div>
                        <div class="row table-row-10">
                            <span>
                                {{ calcStudyDay(DB::table('lessons')->whereIn('id', $item?->structure_program?->lesson_id)->get(), 'practice') }}
                            </span>
                        </div>
                    </div>
                @endforeach
            </div>
            <div class="table-footer">
                @include('admin::components.pagination', ['paginate' => $data])
            </div>
        </div>
    @else
        @component('admin::components.empty', [
            'name' => 'Program CLass is empty',
            'msg' => 'You can create a new program class by clicking the button below.',
            'permission' => 'program-class-create',
            'url' => route('admin-program-class-create'),
            'button' => 'Create Program CLass',
        ])
        @endcomponent
    @endif
</div>
